/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.serde;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cassandra.serde.AbstractColumnSerDe;
import org.apache.hadoop.hive.cassandra.serde.CassandraLazyFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;

public class CassandraColumnSerDe
extends AbstractColumnSerDe {
    public static final String CASSANDRA_VALIDATOR_TYPE = "cassandra.cf.validatorType";
    public static final AbstractType DEFAULT_VALIDATOR_TYPE = BytesType.instance;
    private List<AbstractType> validatorType;

    @Override
    protected void initCassandraSerDeParameters(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        this.cassandraColumnFamily = this.getCassandraColumnFamily(tbl);
        this.cassandraColumnNames = this.parseOrCreateColumnMapping(tbl);
        this.cassandraColumnNamesBytes = new ArrayList();
        for (String columnName : this.cassandraColumnNames) {
            this.cassandraColumnNamesBytes.add(new BytesWritable(columnName.getBytes()));
        }
        this.iKey = this.cassandraColumnNames.indexOf(":key");
        this.serdeParams = LazySimpleSerDe.initSerdeParams(job, tbl, serdeName);
        this.validatorType = this.parseOrCreateValidatorType(tbl);
        this.setTableMapping();
        if (this.cassandraColumnNames.size() != this.serdeParams.getColumnNames().size()) {
            throw new SerDeException(serdeName + ": columns has " + this.serdeParams.getColumnNames().size() + " elements while cassandra.columns.mapping has " + this.cassandraColumnNames.size() + " elements" + " (counting the key if implicit)");
        }
        for (int i = 0; i < this.cassandraColumnNames.size(); ++i) {
            TypeInfo typeInfo;
            String cassandraColName = (String)this.cassandraColumnNames.get(i);
            if (!cassandraColName.endsWith(":") || (typeInfo = this.serdeParams.getColumnTypes().get(i)).getCategory() == ObjectInspector.Category.MAP && ((MapTypeInfo)typeInfo).getMapKeyTypeInfo().getTypeName() == "string") continue;
            throw new SerDeException(serdeName + ": Cassandra column family '" + cassandraColName + "' should be mapped to map<string,?> but is mapped to " + typeInfo.getTypeName());
        }
    }

    @Override
    protected ObjectInspector createObjectInspector() {
        return CassandraLazyFactory.createLazyStructInspector(this.serdeParams.getColumnNames(), this.serdeParams.getColumnTypes(), this.validatorType, this.serdeParams.getSeparators(), this.serdeParams.getNullSequence(), this.serdeParams.isLastColumnTakesRest(), this.serdeParams.isEscaped(), this.serdeParams.getEscapeChar());
    }

    private List<AbstractType> parseOrCreateValidatorType(Properties tbl) throws SerDeException {
        String prop = tbl.getProperty(CASSANDRA_VALIDATOR_TYPE);
        List<AbstractType> result = new ArrayList<AbstractType>();
        if (prop != null) {
            assert (StringUtils.isNotBlank((String)prop));
            String[] validators = prop.split(",");
            String[] trimmedValidators = CassandraColumnSerDe.trim(validators);
            List<String> columnList = Arrays.asList(trimmedValidators);
            result = this.parseValidatorType(columnList);
            if (result.size() < this.cassandraColumnNames.size()) {
                throw new SerDeException("There are fewer validator types defined than the column names. ColumnaName size: " + this.cassandraColumnNames.size() + " ValidatorType size: " + result.size());
            }
        }
        return result;
    }

    private List<AbstractType> parseValidatorType(List<String> columnList) throws SerDeException {
        ArrayList<AbstractType> types = new ArrayList<AbstractType>();
        for (String str : columnList) {
            if (StringUtils.isBlank((String)str)) {
                types.add(DEFAULT_VALIDATOR_TYPE);
                continue;
            }
            try {
                types.add(TypeParser.parse((String)str));
            }
            catch (ConfigurationException e) {
                throw new SerDeException("Invalid Cassandra validator type ' " + str + "'");
            }
        }
        return types;
    }
}

