/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.output;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cassandra.CassandraException;
import org.apache.hadoop.hive.cassandra.CassandraProxyClient;
import org.apache.hadoop.hive.cassandra.output.CassandraPut;
import org.apache.hadoop.hive.cassandra.output.Put;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

public class HiveCassandraOutputFormat
implements HiveOutputFormat<Text, CassandraPut>,
OutputFormat<Text, CassandraPut> {
    static final Log LOG = LogFactory.getLog(HiveCassandraOutputFormat.class);

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(final JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        CassandraProxyClient client;
        final String cassandraKeySpace = jc.get("cassandra.ks.name");
        String cassandraHost = jc.get("cassandra.host");
        int cassandraPort = Integer.parseInt(jc.get("cassandra.port"));
        String username = jc.get("cassandra.input.keyspace.username");
        String password = jc.get("cassandra.input.keyspace.passwd");
        HashMap<String, String> credentials = null;
        if (username != null) {
            credentials = new HashMap<String, String>();
            credentials.put("username", username);
            credentials.put("password", password);
        }
        try {
            client = new CassandraProxyClient(cassandraHost, cassandraPort, cassandraKeySpace, credentials, true, true);
        }
        catch (CassandraException e) {
            throw new IOException(e);
        }
        return new FileSinkOperator.RecordWriter(){

            @Override
            public void close(boolean abort) throws IOException {
                if (client != null) {
                    client.close();
                }
            }

            @Override
            public void write(Writable w) throws IOException {
                Put put = (Put)w;
                put.write(cassandraKeySpace, client, jc);
            }
        };
    }

    public void checkOutputSpecs(FileSystem arg0, JobConf jc) throws IOException {
    }

    public RecordWriter<Text, CassandraPut> getRecordWriter(FileSystem arg0, JobConf arg1, String arg2, Progressable arg3) throws IOException {
        throw new RuntimeException("Error: Hive should not invoke this method.");
    }
}

