/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.output;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.hadoop.hive.cassandra.CassandraProxyClient;
import org.apache.hadoop.hive.cassandra.output.CassandraAbstractPut;
import org.apache.hadoop.hive.cassandra.output.CassandraColumn;
import org.apache.hadoop.hive.cassandra.output.CassandraPut;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;

public class CassandraSuperPut
extends CassandraAbstractPut
implements Writable {
    private ByteBuffer key;
    private List<CassandraPut> subColumns = new ArrayList<CassandraPut>();

    public CassandraSuperPut() {
    }

    public CassandraSuperPut(ByteBuffer key) {
        this();
        this.key = key;
    }

    public void readFields(DataInput in) throws IOException {
        int keyLen = in.readInt();
        byte[] keyBytes = new byte[keyLen];
        in.readFully(keyBytes);
        this.key = ByteBuffer.wrap(keyBytes);
        int ilevel = in.readInt();
        int cols = in.readInt();
        for (int i = 0; i < cols; ++i) {
            CassandraPut cc = new CassandraPut();
            cc.readFields(in);
            this.subColumns.add(cc);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.key.remaining());
        out.write(ByteBufferUtil.getArray((ByteBuffer)this.key));
        out.writeInt(1);
        out.writeInt(this.subColumns.size());
        for (CassandraPut c : this.subColumns) {
            c.write(out);
        }
    }

    public ByteBuffer getKey() {
        return this.key;
    }

    public void setKey(ByteBuffer key) {
        this.key = key;
    }

    public List<CassandraPut> getColumns() {
        return this.subColumns;
    }

    public void setSubColumns(List<CassandraPut> subColumns) {
        this.subColumns = subColumns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("key: ");
        sb.append(this.key);
        for (CassandraPut col : this.subColumns) {
            sb.append("SubColumn : [");
            sb.append(col.toString());
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public void write(String keySpace, CassandraProxyClient client, JobConf jc) throws IOException {
        ConsistencyLevel flevel = CassandraSuperPut.getConsistencyLevel(jc);
        int batchMutation = this.getBatchMutationSize(jc);
        HashMap<ByteBuffer, Map<String, List<Object>>> mutation_map = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
        HashMap<String, ArrayList<Mutation>> maps = new HashMap<String, ArrayList<Mutation>>();
        int count = 0;
        for (CassandraPut c : this.subColumns) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (CassandraColumn col : c.getColumns()) {
                Column cassCol = new Column();
                cassCol.setValue(col.getValue());
                cassCol.setTimestamp(col.getTimeStamp());
                cassCol.setName(col.getColumn());
                columns.add(cassCol);
                ColumnOrSuperColumn thisSuperCol = new ColumnOrSuperColumn();
                thisSuperCol.setSuper_column(new SuperColumn(c.getKey(), columns));
                Mutation mutation = new Mutation();
                mutation.setColumn_or_supercolumn(thisSuperCol);
                ArrayList<Mutation> mutList = (ArrayList<Mutation>)maps.get(col.getColumnFamily());
                if (mutList == null) {
                    mutList = new ArrayList<Mutation>();
                    maps.put(col.getColumnFamily(), mutList);
                }
                mutList.add(mutation);
                if (++count != batchMutation) continue;
                mutation_map.put(this.key, maps);
                this.commitChanges(keySpace, client, flevel, mutation_map);
                mutation_map = new HashMap();
                maps = new HashMap();
                count = 0;
            }
        }
        if (count > 0) {
            mutation_map.put(this.key, maps);
            this.commitChanges(keySpace, client, flevel, mutation_map);
        }
    }
}

