/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.output;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class CassandraColumn
implements Writable {
    private String columnFamily;
    private long timeStamp;
    private byte[] column;
    private byte[] value;

    public void readFields(DataInput din) throws IOException {
        this.columnFamily = din.readUTF();
        this.timeStamp = din.readLong();
        int clength = din.readInt();
        this.column = new byte[clength];
        din.readFully(this.column, 0, clength);
        int vlength = din.readInt();
        this.value = new byte[vlength];
        din.readFully(this.value, 0, vlength);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.columnFamily);
        out.writeLong(this.timeStamp);
        out.writeInt(this.column.length);
        out.write(this.column);
        out.writeInt(this.value.length);
        out.write(this.value);
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public void setColumnFamily(String columnFamily) {
        this.columnFamily = columnFamily;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public void setColumn(byte[] column) {
        this.column = column;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("cf:" + this.columnFamily);
        sb.append("column:" + new String(this.column));
        sb.append("value:" + new String(this.value));
        return sb.toString();
    }
}

