/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.output;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.hadoop.hive.cassandra.CassandraProxyClient;
import org.apache.hadoop.hive.cassandra.output.Put;
import org.apache.hadoop.mapred.JobConf;
import org.apache.thrift.TException;

public abstract class CassandraAbstractPut
implements Put {
    protected int getBatchMutationSize(JobConf jc) {
        return jc.getInt("cassandra.batchmutate.size", 500);
    }

    protected static ConsistencyLevel getConsistencyLevel(JobConf jc) {
        String consistencyLevel = jc.get("cassandra.consistency.level", "ONE");
        ConsistencyLevel level = null;
        try {
            level = ConsistencyLevel.valueOf((String)consistencyLevel);
        }
        catch (IllegalArgumentException e) {
            level = ConsistencyLevel.ONE;
        }
        return level;
    }

    protected void commitChanges(String keySpace, CassandraProxyClient client, ConsistencyLevel flevel, Map<ByteBuffer, Map<String, List<Mutation>>> mutation_map) throws IOException {
        try {
            client.getProxyConnection().set_keyspace(keySpace);
            client.getProxyConnection().batch_mutate(mutation_map, flevel);
        }
        catch (InvalidRequestException e) {
            throw new IOException(e);
        }
        catch (UnavailableException e) {
            throw new IOException(e);
        }
        catch (TimedOutException e) {
            throw new IOException(e);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }
}

