/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public class HiveCassandraStandardSplit
extends FileSplit
implements InputSplit {
    private final ColumnFamilySplit split;
    private String columnMapping;
    private String keyspace;
    private String columnFamily;
    private int rangeBatchSize;
    private int slicePredicateSize;
    private int splitSize;
    private String partitioner;
    private int port;
    private String host;

    public HiveCassandraStandardSplit() {
        super((Path)null, 0L, 0L, (String[])null);
        this.columnMapping = "";
        this.split = new ColumnFamilySplit(null, null, null);
    }

    public HiveCassandraStandardSplit(ColumnFamilySplit split, String columnsMapping, Path dummyPath) {
        super(dummyPath, 0L, 0L, (String[])null);
        this.split = split;
        this.columnMapping = columnsMapping;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.columnMapping = in.readUTF();
        this.keyspace = in.readUTF();
        this.columnFamily = in.readUTF();
        this.splitSize = in.readInt();
        this.rangeBatchSize = in.readInt();
        this.slicePredicateSize = in.readInt();
        this.partitioner = in.readUTF();
        this.port = in.readInt();
        this.host = in.readUTF();
        this.split.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.columnMapping);
        out.writeUTF(this.keyspace);
        out.writeUTF(this.columnFamily);
        out.writeInt(this.splitSize);
        out.writeInt(this.rangeBatchSize);
        out.writeInt(this.slicePredicateSize);
        out.writeUTF(this.partitioner);
        out.writeInt(this.port);
        out.writeUTF(this.host);
        this.split.write(out);
    }

    public String[] getLocations() throws IOException {
        return this.split.getLocations();
    }

    public long getLength() {
        return this.split.getLength();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public void setColumnFamily(String columnFamily) {
        this.columnFamily = columnFamily;
    }

    public int getRangeBatchSize() {
        return this.rangeBatchSize;
    }

    public void setRangeBatchSize(int rangeBatchSize) {
        this.rangeBatchSize = rangeBatchSize;
    }

    public int getSlicePredicateSize() {
        return this.slicePredicateSize;
    }

    public void setSlicePredicateSize(int slicePredicateSize) {
        this.slicePredicateSize = slicePredicateSize;
    }

    public ColumnFamilySplit getSplit() {
        return this.split;
    }

    public String getColumnMapping() {
        return this.columnMapping;
    }

    public void setColumnMapping(String mapping) {
        this.columnMapping = mapping;
    }

    public void setPartitioner(String part) {
        this.partitioner = part;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String toString() {
        return this.host + " " + this.port + " " + this.partitioner;
    }

    public void setSplitSize(int splitSize) {
        this.splitSize = splitSize;
    }

    public int getSplitSize() {
        return this.splitSize;
    }
}

