/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cassandra;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.hadoop.hive.cassandra.CassandraException;
import org.apache.hadoop.hive.cassandra.CassandraProxyClient;
import org.apache.hadoop.hive.cassandra.serde.AbstractColumnSerDe;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;

public class CassandraManager {
    public static final int DEFAULT_REPLICATION_FACTOR = 1;
    public static final String DEFAULT_STRATEGY = "org.apache.cassandra.locator.SimpleStrategy";
    public static final String USERNAME_PROPERTY = "username";
    public static final String PASSWORD_PROPERTY = "password";
    private final String host;
    private final int port;
    private CassandraProxyClient clientHolder;
    private boolean framedConnection;
    private final Table tbl;
    private String keyspace;
    private String username;
    private String password;
    private String columnFamilyName;

    public CassandraManager(Table tbl) throws MetaException {
        String password;
        String userName;
        Map<String, String> serdeParam = tbl.getSd().getSerdeInfo().getParameters();
        String cassandraHost = serdeParam.get("cassandra.host");
        if (cassandraHost == null) {
            cassandraHost = "localhost";
        }
        this.host = cassandraHost;
        String cassandraPortStr = serdeParam.get("cassandra.port");
        if (cassandraPortStr == null) {
            cassandraPortStr = "9160";
        }
        if ((userName = serdeParam.get("cassandra.ks.username")) != null) {
            this.username = userName;
        }
        if ((password = serdeParam.get("cassandra.ks.password")) != null) {
            this.password = password;
        }
        try {
            this.port = Integer.parseInt(cassandraPortStr);
        }
        catch (NumberFormatException e) {
            throw new MetaException("cassandra.port must be a number");
        }
        this.tbl = tbl;
        this.init();
    }

    private void init() {
        this.keyspace = this.getCassandraKeyspace();
        this.columnFamilyName = this.getCassandraColumnFamily();
        this.framedConnection = true;
    }

    public void openConnection() throws MetaException {
        HashMap<String, String> credentials = null;
        if (this.username != null) {
            credentials = new HashMap<String, String>();
            credentials.put(USERNAME_PROPERTY, this.username);
            credentials.put(PASSWORD_PROPERTY, this.password);
        }
        try {
            this.clientHolder = this.username != null ? new CassandraProxyClient(this.host, this.port, this.keyspace, credentials, this.framedConnection, true) : new CassandraProxyClient(this.host, this.port, this.keyspace, this.framedConnection, true);
        }
        catch (CassandraException e) {
            throw new MetaException("Unable to connect to the server " + e.getMessage());
        }
    }

    public void closeConnection() {
        if (this.clientHolder != null) {
            this.clientHolder.close();
        }
    }

    public KsDef getKeyspaceDesc() throws NotFoundException, MetaException {
        try {
            return this.clientHolder.getProxyConnection().describe_keyspace(this.keyspace);
        }
        catch (TException e) {
            throw new MetaException("An internal exception prevented this action from taking place." + e.getMessage());
        }
        catch (InvalidRequestException e) {
            throw new MetaException("An internal exception prevented this action from taking place." + e.getMessage());
        }
    }

    private CfDef getColumnFamily(KsDef ks) {
        for (CfDef cf : ks.getCf_defs()) {
            if (!cf.getName().equalsIgnoreCase(this.columnFamilyName)) continue;
            return cf;
        }
        return null;
    }

    private CfDef getCfDef() throws MetaException {
        CfDef cf = new CfDef();
        cf.setKeyspace(this.keyspace);
        cf.setName(this.columnFamilyName);
        cf.setColumn_type(this.getColumnType());
        return cf;
    }

    public KsDef createKeyspaceWithColumns() throws MetaException {
        try {
            KsDef ks = new KsDef();
            ks.setName(this.getCassandraKeyspace());
            ks.setReplication_factor(this.getReplicationFactor());
            ks.setStrategy_class(this.getStrategy());
            ks.addToCf_defs(this.getCfDef());
            this.clientHolder.getProxyConnection().system_add_keyspace(ks);
            this.clientHolder.getProxyConnection().set_keyspace(this.keyspace);
            return ks;
        }
        catch (TException e) {
            throw new MetaException("Unable to create key space '" + this.keyspace + "'. Error:" + e.getMessage());
        }
        catch (InvalidRequestException e) {
            throw new MetaException("Unable to create key space '" + this.keyspace + "'. Error:" + e.getMessage());
        }
        catch (SchemaDisagreementException e) {
            throw new MetaException("Unable to create key space '" + this.keyspace + "'. Error:" + e.getMessage());
        }
    }

    public CfDef createCFIfNotFound(KsDef ks) throws MetaException {
        CfDef cf = this.getColumnFamily(ks);
        if (cf == null) {
            return this.createColumnFamily();
        }
        return cf;
    }

    public CfDef createColumnFamily() throws MetaException {
        CfDef cf = this.getCfDef();
        try {
            this.clientHolder.getProxyConnection().set_keyspace(this.keyspace);
            this.clientHolder.getProxyConnection().system_add_column_family(cf);
            return cf;
        }
        catch (TException e) {
            throw new MetaException("Unable to create column family '" + this.columnFamilyName + "'. Error:" + e.getMessage());
        }
        catch (InvalidRequestException e) {
            throw new MetaException("Unable to create column family '" + this.columnFamilyName + "'. Error:" + e.getMessage());
        }
        catch (SchemaDisagreementException e) {
            throw new MetaException("Unable to create column family '" + this.columnFamilyName + "'. Error:" + e.getMessage());
        }
    }

    private String getColumnType() throws MetaException {
        List<String> mapping;
        String prop = this.getPropertyFromTable("cassandra.columns.mapping");
        if (prop != null) {
            mapping = AbstractColumnSerDe.parseColumnMapping(prop);
        } else {
            List<FieldSchema> schema = this.tbl.getSd().getCols();
            if (schema.size() == 0) {
                throw new MetaException("Can't find table column definitions");
            }
            String[] colNames = new String[schema.size()];
            for (int i = 0; i < schema.size(); ++i) {
                colNames[i] = schema.get(i).getName();
            }
            String mappingStr = AbstractColumnSerDe.createColumnMappingString(colNames);
            mapping = Arrays.asList(mappingStr.split(","));
        }
        boolean hasKey = false;
        boolean hasColumn = false;
        boolean hasValue = false;
        boolean hasSubColumn = false;
        for (String column : mapping) {
            if (column.equalsIgnoreCase(":key")) {
                hasKey = true;
                continue;
            }
            if (column.equalsIgnoreCase(":column")) {
                hasColumn = true;
                continue;
            }
            if (column.equalsIgnoreCase(":subcolumn")) {
                hasSubColumn = true;
                continue;
            }
            if (column.equalsIgnoreCase(":value")) {
                hasValue = true;
                continue;
            }
            return "Standard";
        }
        if (hasKey && hasColumn && hasValue) {
            if (hasSubColumn) {
                return "Super";
            }
            return "Standard";
        }
        return "Standard";
    }

    private int getReplicationFactor() throws MetaException {
        String prop = this.getPropertyFromTable("cassandra.ks.repfactor");
        if (prop == null) {
            return 1;
        }
        try {
            return Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            throw new MetaException("cassandra.ks.repfactor must be a number");
        }
    }

    private String getStrategy() {
        String prop = this.getPropertyFromTable("cassandra.ks.strategy");
        if (prop == null) {
            return DEFAULT_STRATEGY;
        }
        return prop;
    }

    private String getCassandraKeyspace() {
        String tableName = this.getPropertyFromTable("cassandra.ks.name");
        if (tableName == null) {
            tableName = this.tbl.getDbName();
        }
        this.tbl.getParameters().put("cassandra.ks.name", tableName);
        return tableName;
    }

    private String getCassandraColumnFamily() {
        String tableName = this.getPropertyFromTable("cassandra.cf.name");
        if (tableName == null) {
            tableName = this.tbl.getTableName();
        }
        this.tbl.getParameters().put("cassandra.cf.name", tableName);
        return tableName;
    }

    private String getPropertyFromTable(String columnName) {
        String prop = this.tbl.getParameters().get(columnName);
        if (prop == null) {
            prop = this.tbl.getSd().getSerdeInfo().getParameters().get(columnName);
        }
        return prop;
    }

    public void dropTable() throws MetaException {
        try {
            this.clientHolder.getProxyConnection().system_drop_column_family(this.columnFamilyName);
        }
        catch (TException e) {
            throw new MetaException("Unable to drop column family '" + this.columnFamilyName + "'. Error:" + e.getMessage());
        }
        catch (InvalidRequestException e) {
            throw new MetaException("Unable to drop column family '" + this.columnFamilyName + "'. Error:" + e.getMessage());
        }
        catch (SchemaDisagreementException e) {
            throw new MetaException("Unable to drop column family '" + this.columnFamilyName + "'. Error:" + e.getMessage());
        }
    }
}

