/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.types.ObjectLongConverter;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManager {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final ClassLoaderResolver clr;
    Map<String, JavaType> javaTypes = new HashMap<String, JavaType>();
    Map<Class, ObjectStringConverter> stringConvertersByType = null;
    Map<Class, ObjectLongConverter> longConvertersByType = null;

    public TypeManager(ApiAdapter api, PluginManager mgr, ClassLoaderResolver clr) {
        this.clr = clr;
        this.loadJavaTypes(mgr, clr);
    }

    public Set<String> getSupportedSecondClassTypes() {
        return new HashSet<String>(this.javaTypes.keySet());
    }

    public boolean isSupportedSecondClassType(String className) {
        if (className == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(className);
        if (type == null) {
            try {
                Class cls = this.clr.classForName(className);
                type = this.findJavaTypeForClass(cls);
                return type != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public String[] filterOutSupportedSecondClassNames(String[] inputClassNames) {
        int filteredClasses = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (!this.isSupportedSecondClassType(inputClassNames[i])) continue;
            inputClassNames[i] = null;
            ++filteredClasses;
        }
        if (filteredClasses == 0) {
            return inputClassNames;
        }
        String[] restClasses = new String[inputClassNames.length - filteredClasses];
        int m = 0;
        for (int i = 0; i < inputClassNames.length; ++i) {
            if (inputClassNames[i] == null) continue;
            restClasses[m++] = inputClassNames[i];
        }
        return restClasses;
    }

    public boolean isDefaultPersistent(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.persistent;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.persistent;
        }
        return false;
    }

    public boolean isDefaultFetchGroup(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.dfg;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    public boolean isDefaultFetchGroupForCollection(Class c, Class genericType) {
        if (c != null && genericType == null) {
            return this.isDefaultFetchGroup(c);
        }
        if (c == null) {
            return false;
        }
        String name = c.getName() + "<" + genericType.getName() + ">";
        JavaType type = this.javaTypes.get(name);
        if (type != null) {
            return type.dfg;
        }
        type = this.findJavaTypeForCollectionClass(c, genericType);
        if (type != null) {
            return type.dfg;
        }
        return false;
    }

    public boolean isDefaultEmbeddedType(Class c) {
        if (c == null) {
            return false;
        }
        JavaType type = this.javaTypes.get(c.getName());
        if (type != null) {
            return type.embedded;
        }
        type = this.findJavaTypeForClass(c);
        if (type != null) {
            return type.embedded;
        }
        return false;
    }

    public boolean isSecondClassMutableType(String className) {
        return this.getWrapperTypeForType(className) != null;
    }

    public Class getWrapperTypeForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperType;
    }

    public Class getWrappedTypeBackedForType(String className) {
        if (className == null) {
            return null;
        }
        JavaType type = this.javaTypes.get(className);
        return type == null ? null : type.wrapperTypeBacked;
    }

    public boolean isSecondClassWrapper(String className) {
        if (className == null) {
            return false;
        }
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return true;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public Class getTypeForSecondClassWrapper(String className) {
        for (JavaType type : this.javaTypes.values()) {
            if (type.wrapperType != null && type.wrapperType.getName().equals(className)) {
                return type.cls;
            }
            if (type.wrapperTypeBacked == null || !type.wrapperTypeBacked.getName().equals(className)) continue;
            return type.cls;
        }
        return null;
    }

    public ObjectStringConverter getStringConverter(Class type) {
        ObjectStringConverter converter = null;
        if (this.stringConvertersByType != null && (converter = this.stringConvertersByType.get(type)) != null) {
            return converter;
        }
        JavaType javaType = this.findJavaTypeForClass(type);
        if (javaType != null && javaType.stringConverter != null) {
            try {
                converter = (ObjectStringConverter)javaType.stringConverter.newInstance();
                if (converter != null) {
                    if (this.stringConvertersByType == null) {
                        this.stringConvertersByType = new Hashtable<Class, ObjectStringConverter>();
                    }
                    this.stringConvertersByType.put(type, converter);
                }
                return converter;
            }
            catch (Exception e) {
                throw new NucleusUserException("Error instantiating string converter for type=" + type.getName(), e);
            }
        }
        return null;
    }

    public ObjectLongConverter getLongConverter(Class type) {
        ObjectLongConverter converter = null;
        if (this.longConvertersByType != null && (converter = this.longConvertersByType.get(type)) != null) {
            return converter;
        }
        JavaType javaType = this.findJavaTypeForClass(type);
        if (javaType != null && javaType.longConverter != null) {
            try {
                converter = (ObjectLongConverter)javaType.longConverter.newInstance();
                if (converter != null) {
                    if (this.longConvertersByType == null) {
                        this.longConvertersByType = new Hashtable<Class, ObjectLongConverter>();
                    }
                    this.longConvertersByType.put(type, converter);
                }
                return converter;
            }
            catch (Exception e) {
                throw new NucleusUserException("Error instantiating long converter for type=" + type.getName(), e);
            }
        }
        return null;
    }

    protected JavaType findJavaTypeForClass(Class cls) {
        if (cls == null) {
            return null;
        }
        JavaType type2 = this.javaTypes.get(cls.getName());
        if (type2 != null) {
            return type2;
        }
        HashSet<JavaType> supportedTypes = new HashSet<JavaType>(this.javaTypes.values());
        for (JavaType type2 : supportedTypes) {
            Class<?> componentCls;
            if (type2.cls == cls && type2.genericType == null) {
                return type2;
            }
            if (type2.cls.getName().equals("java.lang.Object") || type2.cls.getName().equals("java.io.Serializable")) continue;
            Class<?> clazz = componentCls = cls.isArray() ? cls.getComponentType() : null;
            if (componentCls != null) {
                if (!type2.cls.isArray() || !type2.cls.getComponentType().isAssignableFrom(componentCls)) continue;
                this.javaTypes.put(cls.getName(), type2);
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016001", (Object)cls.getName(), (Object)type2.cls.getName()));
                }
                return type2;
            }
            if (!type2.cls.isAssignableFrom(cls) || type2.genericType != null) continue;
            this.javaTypes.put(cls.getName(), type2);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016001", (Object)cls.getName(), (Object)type2.cls.getName()));
            }
            return type2;
        }
        return null;
    }

    protected JavaType findJavaTypeForCollectionClass(Class cls, Class genericType) {
        if (cls == null) {
            return null;
        }
        if (genericType == null) {
            return this.findJavaTypeForClass(cls);
        }
        String typeName = cls.getName() + "<" + genericType.getName() + ">";
        JavaType type2 = this.javaTypes.get(typeName);
        if (type2 != null) {
            return type2;
        }
        HashSet<JavaType> supportedTypes = new HashSet<JavaType>(this.javaTypes.values());
        for (JavaType type2 : supportedTypes) {
            if (!type2.cls.isAssignableFrom(cls) || type2.genericType == null || !type2.genericType.isAssignableFrom(genericType)) continue;
            this.javaTypes.put(typeName, type2);
            return type2;
        }
        return this.findJavaTypeForClass(cls);
    }

    private void loadJavaTypes(PluginManager mgr, ClassLoaderResolver clr) {
        ConfigurationElement[] elems = mgr.getConfigurationElementsForExtension("org.datanucleus.java_type", (String)null, (String)null);
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                String javaName = elems[i].getAttribute("name").trim();
                String genericTypeName = elems[i].getAttribute("generic-type");
                String persistentString = elems[i].getAttribute("persistent");
                String embeddedString = elems[i].getAttribute("embedded");
                String dfgString = elems[i].getAttribute("dfg");
                String javaVersionRestrict = elems[i].getAttribute("java-version-restricted");
                String javaVersion = elems[i].getAttribute("java-version");
                String wrapperType = elems[i].getAttribute("wrapper-type");
                String wrapperTypeBacked = elems[i].getAttribute("wrapper-type-backed");
                String stringConverterName = elems[i].getAttribute("string-converter");
                String longConverterName = elems[i].getAttribute("long-converter");
                boolean persistent = false;
                if (persistentString != null && persistentString.equalsIgnoreCase("true")) {
                    persistent = true;
                }
                boolean embedded = false;
                if (embeddedString != null && embeddedString.equalsIgnoreCase("true")) {
                    embedded = true;
                }
                boolean dfg = false;
                if (dfgString != null && dfgString.equalsIgnoreCase("true")) {
                    dfg = true;
                }
                boolean versionRestricted = false;
                if (javaVersionRestrict != null && javaVersionRestrict.equalsIgnoreCase("true")) {
                    versionRestricted = true;
                }
                wrapperType = !StringUtils.isWhitespace(wrapperType) ? wrapperType.trim() : null;
                wrapperTypeBacked = !StringUtils.isWhitespace(wrapperTypeBacked) ? wrapperTypeBacked.trim() : null;
                stringConverterName = !StringUtils.isWhitespace(stringConverterName) ? stringConverterName.trim() : null;
                longConverterName = !StringUtils.isWhitespace(longConverterName) ? longConverterName.trim() : null;
                if (StringUtils.isWhitespace(javaVersion)) {
                    javaVersion = "1.3";
                }
                if ((!JavaUtils.isGreaterEqualsThan(javaVersion) || versionRestricted) && (!JavaUtils.isEqualsThan(javaVersion) || !versionRestricted)) continue;
                try {
                    Class cls = clr.classForName(javaName);
                    Class genericType = null;
                    String javaTypeName = cls.getName();
                    if (!StringUtils.isWhitespace(genericTypeName)) {
                        genericType = clr.classForName(genericTypeName);
                        javaTypeName = javaTypeName + "<" + genericTypeName + ">";
                    }
                    if (this.javaTypes.containsKey(javaTypeName)) continue;
                    Class wrapperClass = null;
                    if (wrapperType != null) {
                        try {
                            wrapperClass = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), wrapperType);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)wrapperType));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)wrapperType));
                        }
                    }
                    Class wrapperClassBacked = null;
                    if (wrapperTypeBacked != null) {
                        try {
                            wrapperClassBacked = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), wrapperTypeBacked);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)wrapperTypeBacked));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)wrapperTypeBacked));
                        }
                    }
                    Class stringConverterClass = null;
                    if (stringConverterName != null) {
                        try {
                            stringConverterClass = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), stringConverterName);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)stringConverterName));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)stringConverterName));
                        }
                    }
                    Class longConverterClass = null;
                    if (longConverterName != null) {
                        try {
                            longConverterClass = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), longConverterName);
                        }
                        catch (NucleusException jpe) {
                            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)longConverterName));
                            throw new NucleusException(LOCALISER.msg("016004", (Object)longConverterName));
                        }
                    }
                    JavaType type = new JavaType(cls, genericType, persistent, embedded, dfg, wrapperClass, wrapperClassBacked, stringConverterClass, longConverterClass);
                    this.addJavaType(type);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    protected void addJavaType(JavaType type) {
        String typeName = type.cls.getName();
        if (type.genericType != null) {
            typeName = typeName + "<" + type.genericType.getName() + ">";
        }
        this.javaTypes.put(typeName, type);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016000", (Object)typeName, (Object)("" + type.persistent), (Object)("" + type.dfg), (Object)("" + type.embedded)));
        }
    }

    static class JavaType {
        final Class cls;
        final Class genericType;
        final boolean persistent;
        final boolean embedded;
        final boolean dfg;
        final Class wrapperType;
        final Class wrapperTypeBacked;
        final Class stringConverter;
        final Class longConverter;

        public JavaType(Class cls, Class genericType, boolean persistent, boolean embedded, boolean dfg, Class wrapperType, Class wrapperTypeBacked, Class stringConverter, Class longConverter) {
            this.cls = cls;
            this.genericType = genericType;
            this.persistent = persistent;
            this.embedded = embedded;
            this.dfg = dfg;
            this.wrapperType = wrapperType;
            this.wrapperTypeBacked = wrapperTypeBacked != null ? wrapperTypeBacked : wrapperType;
            this.stringConverter = stringConverter;
            this.longConverter = longConverter;
        }
    }
}

