/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

public class CalendarStringConverter
implements ObjectStringConverter {
    static SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");

    public Object toObject(String str) {
        if (str == null) {
            return null;
        }
        try {
            Date date = format.parse(str);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException pe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Calendar.class.getName()), pe);
        }
    }

    public String toString(Object obj) {
        String str = obj instanceof Calendar ? format.format(((Calendar)obj).getTime()) : (String)obj;
        return str;
    }
}

