/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.util.VersionInfo;

public abstract class Storage
extends StorageInfo {
    public static final Log LOG = LogFactory.getLog((String)Storage.class.getName());
    protected static final int LAST_PRE_UPGRADE_LAYOUT_VERSION = -3;
    public static final int LAST_UPGRADABLE_LAYOUT_VERSION = -7;
    protected static final String LAST_UPGRADABLE_HADOOP_VERSION = "Hadoop-0.14";
    public static final int PRE_GENERATIONSTAMP_LAYOUT_VERSION = -13;
    public static final int LAYOUT_VERSION_21 = -24;
    private static final String STORAGE_FILE_LOCK = "in_use.lock";
    protected static final String STORAGE_FILE_VERSION = "VERSION";
    public static final String STORAGE_DIR_CURRENT = "current";
    private static final String STORAGE_DIR_PREVIOUS = "previous";
    private static final String STORAGE_TMP_REMOVED = "removed.tmp";
    private static final String STORAGE_TMP_PREVIOUS = "previous.tmp";
    private static final String STORAGE_TMP_FINALIZED = "finalized.tmp";
    private static final String STORAGE_TMP_LAST_CKPT = "lastcheckpoint.tmp";
    private static final String STORAGE_PREVIOUS_CKPT = "previous.checkpoint";
    private HdfsConstants.NodeType storageType;
    protected List<StorageDirectory> storageDirs = new ArrayList<StorageDirectory>();

    public Iterator<StorageDirectory> dirIterator() {
        return this.dirIterator(null);
    }

    public Iterator<StorageDirectory> dirIterator(StorageDirType dirType) {
        return new DirIterator(dirType);
    }

    protected Storage(HdfsConstants.NodeType type) {
        this.storageType = type;
    }

    protected Storage(HdfsConstants.NodeType type, int nsID, long cT) {
        super(-31, nsID, cT);
        this.storageType = type;
    }

    protected Storage(HdfsConstants.NodeType type, StorageInfo storageInfo) {
        super(storageInfo);
        this.storageType = type;
    }

    public int getNumStorageDirs() {
        return this.storageDirs.size();
    }

    public StorageDirectory getStorageDir(int idx) {
        return this.storageDirs.get(idx);
    }

    protected void addStorageDir(StorageDirectory sd) {
        this.storageDirs.add(sd);
    }

    public abstract boolean isConversionNeeded(StorageDirectory var1) throws IOException;

    private void checkConversionNeeded(StorageDirectory sd) throws IOException {
        if (this.isConversionNeeded(sd)) {
            Storage.checkVersionUpgradable(0);
        }
    }

    public static void checkVersionUpgradable(int oldVersion) throws IOException {
        if (oldVersion > -7) {
            String msg = "*********** Upgrade is not supported from this older version of storage to the current version. Please upgrade to Hadoop-0.14 or a later version and then upgrade to current version. Old layout version is " + (oldVersion == 0 ? "'too old'" : "" + oldVersion) + " and latest layout version this software version can" + " upgrade from is " + -7 + ". ************";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        if (oldVersion == -24) {
            String msg = "*********** Upgrade is not supported from this  version of storage to the current version. Please upgrade to release 0.22  or a later version and then upgrade to current version. Old layout version is " + oldVersion + ". ************";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    protected void getFields(Properties props, StorageDirectory sd) throws IOException {
        String sv = props.getProperty("layoutVersion");
        String st = props.getProperty("storageType");
        String sid = props.getProperty("namespaceID");
        String sct = props.getProperty("cTime");
        if (sv == null || st == null || sid == null || sct == null) {
            throw new InconsistentFSStateException(sd.root, "file VERSION is invalid.");
        }
        int rv = Integer.parseInt(sv);
        HdfsConstants.NodeType rt = HdfsConstants.NodeType.valueOf(st);
        int rid = Integer.parseInt(sid);
        long rct = Long.parseLong(sct);
        if (!this.storageType.equals((Object)rt) || this.namespaceID != 0 && rid != 0 && this.namespaceID != rid) {
            throw new InconsistentFSStateException(sd.root, "is incompatible with others.");
        }
        if (rv < -31) {
            throw new IncorrectVersionException(rv, "storage directory " + sd.root.getCanonicalPath());
        }
        this.layoutVersion = rv;
        this.storageType = rt;
        this.namespaceID = rid;
        this.cTime = rct;
    }

    protected void setFields(Properties props, StorageDirectory sd) throws IOException {
        props.setProperty("layoutVersion", String.valueOf(this.layoutVersion));
        props.setProperty("storageType", this.storageType.toString());
        props.setProperty("namespaceID", String.valueOf(this.namespaceID));
        props.setProperty("cTime", String.valueOf(this.cTime));
    }

    public static void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Failed to rename " + from.getCanonicalPath() + " to " + to.getCanonicalPath());
        }
    }

    protected static void deleteDir(File dir) throws IOException {
        if (!FileUtil.fullyDelete(dir)) {
            throw new IOException("Failed to delete " + dir.getCanonicalPath());
        }
    }

    public void writeAll() throws IOException {
        this.layoutVersion = -31;
        Iterator<StorageDirectory> it = this.storageDirs.iterator();
        while (it.hasNext()) {
            it.next().write();
        }
    }

    public void unlockAll() throws IOException {
        Iterator<StorageDirectory> it = this.storageDirs.iterator();
        while (it.hasNext()) {
            it.next().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockSupported(int idx) throws IOException {
        StorageDirectory sd = this.storageDirs.get(idx);
        FileLock firstLock = null;
        FileLock secondLock = null;
        try {
            firstLock = sd.lock;
            if (firstLock == null && (firstLock = sd.tryLock()) == null) {
                boolean bl = true;
                return bl;
            }
            secondLock = sd.tryLock();
            if (secondLock == null) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (firstLock != null && firstLock != sd.lock) {
                firstLock.release();
                firstLock.channel().close();
            }
            if (secondLock != null) {
                secondLock.release();
                secondLock.channel().close();
            }
        }
        return false;
    }

    public static String getBuildVersion() {
        return VersionInfo.getRevision();
    }

    public static String getRegistrationID(StorageInfo storage) {
        return "NS-" + Integer.toString(storage.getNamespaceID()) + "-" + Integer.toString(storage.getLayoutVersion()) + "-" + Long.toString(storage.getCTime());
    }

    protected abstract void corruptPreUpgradeStorage(File var1) throws IOException;

    protected void writeCorruptedData(RandomAccessFile file) throws IOException {
        String messageForPreUpgradeVersion = "\nThis file is INTENTIONALLY CORRUPTED so that versions\nof Hadoop prior to 0.13 (which are incompatible\nwith this directory layout) will fail to start.\n";
        file.seek(0L);
        file.writeInt(-31);
        UTF8.writeString(file, "");
        file.writeBytes("\nThis file is INTENTIONALLY CORRUPTED so that versions\nof Hadoop prior to 0.13 (which are incompatible\nwith this directory layout) will fail to start.\n");
        file.getFD().sync();
    }

    public class StorageDirectory {
        File root;
        FileLock lock;
        StorageDirType dirType;

        public StorageDirectory(File dir) {
            this(dir, null);
        }

        public StorageDirectory(File dir, StorageDirType dirType) {
            this.root = dir;
            this.lock = null;
            this.dirType = dirType;
        }

        public File getRoot() {
            return this.root;
        }

        public StorageDirType getStorageDirType() {
            return this.dirType;
        }

        public void read() throws IOException {
            this.read(this.getVersionFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(File from) throws IOException {
            RandomAccessFile file = new RandomAccessFile(from, "rws");
            FileInputStream in = null;
            try {
                in = new FileInputStream(file.getFD());
                file.seek(0L);
                Properties props = new Properties();
                props.load(in);
                Storage.this.getFields(props, this);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                file.close();
            }
        }

        public void write() throws IOException {
            Storage.this.corruptPreUpgradeStorage(this.root);
            this.write(this.getVersionFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(File to) throws IOException {
            Properties props = new Properties();
            Storage.this.setFields(props, this);
            RandomAccessFile file = new RandomAccessFile(to, "rws");
            FileOutputStream out = null;
            try {
                file.seek(0L);
                out = new FileOutputStream(file.getFD());
                props.store(out, null);
                file.setLength(out.getChannel().position());
            }
            finally {
                if (out != null) {
                    out.close();
                }
                file.close();
            }
        }

        public void clearDirectory() throws IOException {
            File curDir = this.getCurrentDir();
            if (curDir.exists() && !FileUtil.fullyDelete(curDir)) {
                throw new IOException("Cannot remove current directory: " + curDir);
            }
            if (!curDir.mkdirs()) {
                throw new IOException("Cannot create directory " + curDir);
            }
        }

        public File getCurrentDir() {
            return new File(this.root, Storage.STORAGE_DIR_CURRENT);
        }

        public File getVersionFile() {
            return new File(new File(this.root, Storage.STORAGE_DIR_CURRENT), Storage.STORAGE_FILE_VERSION);
        }

        public File getPreviousVersionFile() {
            return new File(new File(this.root, Storage.STORAGE_DIR_PREVIOUS), Storage.STORAGE_FILE_VERSION);
        }

        public File getPreviousDir() {
            return new File(this.root, Storage.STORAGE_DIR_PREVIOUS);
        }

        public File getPreviousTmp() {
            return new File(this.root, Storage.STORAGE_TMP_PREVIOUS);
        }

        public File getRemovedTmp() {
            return new File(this.root, Storage.STORAGE_TMP_REMOVED);
        }

        public File getFinalizedTmp() {
            return new File(this.root, Storage.STORAGE_TMP_FINALIZED);
        }

        public File getLastCheckpointTmp() {
            return new File(this.root, Storage.STORAGE_TMP_LAST_CKPT);
        }

        public File getPreviousCheckpoint() {
            return new File(this.root, Storage.STORAGE_PREVIOUS_CKPT);
        }

        public StorageState analyzeStorage(HdfsConstants.StartupOption startOpt) throws IOException {
            assert (this.root != null) : "root is null";
            String rootPath = this.root.getCanonicalPath();
            try {
                if (!this.root.exists()) {
                    if (startOpt != HdfsConstants.StartupOption.FORMAT) {
                        LOG.info((Object)("Storage directory " + rootPath + " does not exist."));
                        return StorageState.NON_EXISTENT;
                    }
                    LOG.info((Object)(rootPath + " does not exist. Creating ..."));
                    if (!this.root.mkdirs()) {
                        throw new IOException("Cannot create directory " + rootPath);
                    }
                }
                if (!this.root.isDirectory()) {
                    LOG.info((Object)(rootPath + "is not a directory."));
                    return StorageState.NON_EXISTENT;
                }
                if (!this.root.canWrite()) {
                    LOG.info((Object)("Cannot access storage directory " + rootPath));
                    return StorageState.NON_EXISTENT;
                }
            }
            catch (SecurityException ex) {
                LOG.info((Object)("Cannot access storage directory " + rootPath), (Throwable)ex);
                return StorageState.NON_EXISTENT;
            }
            this.lock();
            if (startOpt == HdfsConstants.StartupOption.FORMAT) {
                return StorageState.NOT_FORMATTED;
            }
            if (startOpt != HdfsConstants.StartupOption.IMPORT) {
                Storage.this.checkConversionNeeded(this);
            }
            File versionFile = this.getVersionFile();
            boolean hasCurrent = versionFile.exists();
            boolean hasPrevious = this.getPreviousDir().exists();
            boolean hasPreviousTmp = this.getPreviousTmp().exists();
            boolean hasRemovedTmp = this.getRemovedTmp().exists();
            boolean hasFinalizedTmp = this.getFinalizedTmp().exists();
            boolean hasCheckpointTmp = this.getLastCheckpointTmp().exists();
            if (!(hasPreviousTmp || hasRemovedTmp || hasFinalizedTmp || hasCheckpointTmp)) {
                if (hasCurrent) {
                    return StorageState.NORMAL;
                }
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "version file in current directory is missing.");
                }
                return StorageState.NOT_FORMATTED;
            }
            if ((hasPreviousTmp ? 1 : 0) + (hasRemovedTmp ? 1 : 0) + (hasFinalizedTmp ? 1 : 0) + (hasCheckpointTmp ? 1 : 0) > 1) {
                throw new InconsistentFSStateException(this.root, "too many temporary directories.");
            }
            if (hasCheckpointTmp) {
                return hasCurrent ? StorageState.COMPLETE_CHECKPOINT : StorageState.RECOVER_CHECKPOINT;
            }
            if (hasFinalizedTmp) {
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "previous and finalized.tmpcannot exist together.");
                }
                return StorageState.COMPLETE_FINALIZE;
            }
            if (hasPreviousTmp) {
                if (hasPrevious) {
                    throw new InconsistentFSStateException(this.root, "previous and previous.tmp cannot exist together.");
                }
                if (hasCurrent) {
                    return StorageState.COMPLETE_UPGRADE;
                }
                return StorageState.RECOVER_UPGRADE;
            }
            assert (hasRemovedTmp) : "hasRemovedTmp must be true";
            if (!(hasCurrent ^ hasPrevious)) {
                throw new InconsistentFSStateException(this.root, "one and only one directory current or previous must be present when removed.tmp exists.");
            }
            if (hasCurrent) {
                return StorageState.COMPLETE_ROLLBACK;
            }
            return StorageState.RECOVER_ROLLBACK;
        }

        public void doRecover(StorageState curState) throws IOException {
            File curDir = this.getCurrentDir();
            String rootPath = this.root.getCanonicalPath();
            switch (curState) {
                case COMPLETE_UPGRADE: {
                    LOG.info((Object)("Completing previous upgrade for storage directory " + rootPath + "."));
                    Storage.rename(this.getPreviousTmp(), this.getPreviousDir());
                    return;
                }
                case RECOVER_UPGRADE: {
                    LOG.info((Object)("Recovering storage directory " + rootPath + " from previous upgrade."));
                    if (curDir.exists()) {
                        Storage.deleteDir(curDir);
                    }
                    Storage.rename(this.getPreviousTmp(), curDir);
                    return;
                }
                case COMPLETE_ROLLBACK: {
                    LOG.info((Object)("Completing previous rollback for storage directory " + rootPath + "."));
                    Storage.deleteDir(this.getRemovedTmp());
                    return;
                }
                case RECOVER_ROLLBACK: {
                    LOG.info((Object)("Recovering storage directory " + rootPath + " from previous rollback."));
                    Storage.rename(this.getRemovedTmp(), curDir);
                    return;
                }
                case COMPLETE_FINALIZE: {
                    LOG.info((Object)("Completing previous finalize for storage directory " + rootPath + "."));
                    Storage.deleteDir(this.getFinalizedTmp());
                    return;
                }
                case COMPLETE_CHECKPOINT: {
                    LOG.info((Object)("Completing previous checkpoint for storage directory " + rootPath + "."));
                    File prevCkptDir = this.getPreviousCheckpoint();
                    if (prevCkptDir.exists()) {
                        Storage.deleteDir(prevCkptDir);
                    }
                    Storage.rename(this.getLastCheckpointTmp(), prevCkptDir);
                    return;
                }
                case RECOVER_CHECKPOINT: {
                    LOG.info((Object)("Recovering storage directory " + rootPath + " from failed checkpoint."));
                    if (curDir.exists()) {
                        Storage.deleteDir(curDir);
                    }
                    Storage.rename(this.getLastCheckpointTmp(), curDir);
                    return;
                }
            }
            throw new IOException("Unexpected FS state: " + (Object)((Object)curState));
        }

        public void lock() throws IOException {
            this.lock = this.tryLock();
            if (this.lock == null) {
                String msg = "Cannot lock storage " + this.root + ". The directory is already locked.";
                LOG.info((Object)msg);
                throw new IOException(msg);
            }
        }

        FileLock tryLock() throws IOException {
            File lockF = new File(this.root, Storage.STORAGE_FILE_LOCK);
            lockF.deleteOnExit();
            RandomAccessFile file = new RandomAccessFile(lockF, "rws");
            FileLock res = null;
            try {
                res = file.getChannel().tryLock();
            }
            catch (OverlappingFileLockException oe) {
                file.close();
                return null;
            }
            catch (IOException e) {
                LOG.error((Object)("Cannot create lock on " + lockF), (Throwable)e);
                file.close();
                throw e;
            }
            return res;
        }

        public void unlock() throws IOException {
            if (this.lock == null) {
                return;
            }
            this.lock.release();
            this.lock.channel().close();
            this.lock = null;
        }
    }

    private class DirIterator
    implements Iterator<StorageDirectory> {
        StorageDirType dirType;
        int prevIndex;
        int nextIndex;

        DirIterator(StorageDirType dirType) {
            this.dirType = dirType;
            this.nextIndex = 0;
            this.prevIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (Storage.this.storageDirs.isEmpty() || this.nextIndex >= Storage.this.storageDirs.size()) {
                return false;
            }
            if (this.dirType != null) {
                while (this.nextIndex < Storage.this.storageDirs.size() && !Storage.this.getStorageDir(this.nextIndex).getStorageDirType().isOfType(this.dirType)) {
                    ++this.nextIndex;
                }
                if (this.nextIndex >= Storage.this.storageDirs.size()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public StorageDirectory next() {
            StorageDirectory sd = Storage.this.getStorageDir(this.nextIndex);
            this.prevIndex = this.nextIndex++;
            if (this.dirType != null) {
                while (this.nextIndex < Storage.this.storageDirs.size() && !Storage.this.getStorageDir(this.nextIndex).getStorageDirType().isOfType(this.dirType)) {
                    ++this.nextIndex;
                }
            }
            return sd;
        }

        @Override
        public void remove() {
            this.nextIndex = this.prevIndex;
            Storage.this.storageDirs.remove(this.prevIndex);
            this.hasNext();
        }
    }

    public static interface StorageDirType {
        public StorageDirType getStorageDirType();

        public boolean isOfType(StorageDirType var1);
    }

    public static enum StorageState {
        NON_EXISTENT,
        NOT_FORMATTED,
        COMPLETE_UPGRADE,
        RECOVER_UPGRADE,
        COMPLETE_FINALIZE,
        COMPLETE_ROLLBACK,
        RECOVER_ROLLBACK,
        COMPLETE_CHECKPOINT,
        RECOVER_CHECKPOINT,
        NORMAL;

    }
}

