/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.table.PersistableJoinTable;
import org.datanucleus.store.scostore.PersistableRelationStore;

public class RDBMSPersistableRelationStore
implements PersistableRelationStore {
    protected RDBMSStoreManager storeMgr;
    protected DatastoreAdapter dba;
    protected JavaTypeMapping ownerMapping;
    protected AbstractMemberMetaData ownerMemberMetaData;
    protected PersistableJoinTable joinTable;
    protected ClassLoaderResolver clr;
    protected String addStmt;
    protected String updateStmt;
    protected String removeStmt;

    public RDBMSPersistableRelationStore(AbstractMemberMetaData mmd, PersistableJoinTable joinTable, ClassLoaderResolver clr) {
        this.storeMgr = (RDBMSStoreManager)joinTable.getStoreManager();
        this.dba = this.storeMgr.getDatastoreAdapter();
        this.ownerMemberMetaData = mmd;
        this.joinTable = joinTable;
        this.clr = clr;
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ObjectProvider sm1, ObjectProvider sm2) {
        boolean bl;
        String addStmt = this.getAddStmt();
        ExecutionContext ec = sm1.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, addStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = RDBMSPersistableRelationStore.populateOwnerInStatement(sm1, ec, ps, jdbcPosition, this.joinTable);
            BackingStoreHelper.populateElementInStatement(ec, ps, sm2.getObject(), jdbcPosition, this.joinTable.getRelatedMapping());
            int[] nums = sqlControl.executeStatementUpdate(mconn, addStmt, ps, true);
            bl = nums != null && nums.length == 1 && nums[0] == 1;
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(mconn, ps);
                mconn.release();
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException("Exception thrown inserting row into persistable relation join table", (Throwable)sqle);
            }
        }
        sqlControl.closeStatement(mconn, ps);
        mconn.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ObjectProvider sm1) {
        boolean bl;
        String removeStmt = this.getRemoveStmt();
        ExecutionContext ec = sm1.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeStmt, false);
        try {
            int jdbcPosition = 1;
            RDBMSPersistableRelationStore.populateOwnerInStatement(sm1, ec, ps, jdbcPosition, this.joinTable);
            int[] nums = sqlControl.executeStatementUpdate(mconn, removeStmt, ps, true);
            bl = nums != null && nums.length == 1 && nums[0] == 1;
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(mconn, ps);
                mconn.release();
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException("Exception thrown deleting row from persistable relation join table", (Throwable)sqle);
            }
        }
        sqlControl.closeStatement(mconn, ps);
        mconn.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ObjectProvider sm1, ObjectProvider sm2) {
        boolean bl;
        String updateStmt = this.getUpdateStmt();
        ExecutionContext ec = sm1.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, sm2.getObject(), jdbcPosition, this.joinTable.getRelatedMapping());
            RDBMSPersistableRelationStore.populateOwnerInStatement(sm1, ec, ps, jdbcPosition, this.joinTable);
            int[] nums = sqlControl.executeStatementUpdate(mconn, updateStmt, ps, true);
            bl = nums != null && nums.length == 1 && nums[0] == 1;
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(mconn, ps);
                mconn.release();
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new NucleusDataStoreException("Exception thrown updating row into persistable relation join table", (Throwable)sqle);
            }
        }
        sqlControl.closeStatement(mconn, ps);
        mconn.release();
        return bl;
    }

    protected String getAddStmt() {
        if (this.addStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = this.joinTable.getOwnerMapping();
            JavaTypeMapping relatedMapping = this.joinTable.getRelatedMapping();
            StringBuffer stmt = new StringBuffer();
            stmt.append("INSERT INTO ");
            stmt.append(this.joinTable.toString());
            stmt.append(" (");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
            for (i = 0; i < relatedMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(relatedMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
            stmt.append(") VALUES (");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getInsertionInputParameter());
            }
            for (i = 0; i < relatedMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)relatedMapping.getDatastoreMapping(0)).getInsertionInputParameter());
            }
            stmt.append(") ");
            this.addStmt = stmt.toString();
        }
        return this.addStmt;
    }

    protected String getUpdateStmt() {
        if (this.updateStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = this.joinTable.getOwnerMapping();
            JavaTypeMapping relatedMapping = this.joinTable.getRelatedMapping();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            stmt.append(this.joinTable.toString());
            stmt.append(" SET ");
            for (i = 0; i < relatedMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(relatedMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getInsertionInputParameter());
            }
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getInsertionInputParameter());
            }
            this.updateStmt = stmt.toString();
        }
        return this.updateStmt;
    }

    protected String getRemoveStmt() {
        if (this.removeStmt == null) {
            JavaTypeMapping ownerMapping = this.joinTable.getOwnerMapping();
            StringBuffer stmt = new StringBuffer();
            stmt.append("DELETE FROM ");
            stmt.append(this.joinTable.toString());
            stmt.append(" WHERE ");
            for (int i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getInsertionInputParameter());
            }
            this.removeStmt = stmt.toString();
        }
        return this.removeStmt;
    }

    public static int populateOwnerInStatement(ObjectProvider sm, ExecutionContext ec, Object ps, int jdbcPosition, PersistableJoinTable joinTable) {
        if (!joinTable.getStoreManager().insertValuesOnInsert(joinTable.getOwnerMapping().getDatastoreMapping(0))) {
            return jdbcPosition;
        }
        if (joinTable.getOwnerMemberMetaData() != null) {
            joinTable.getOwnerMapping().setObject(ec, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)joinTable.getOwnerMapping()), sm.getObject(), sm, joinTable.getOwnerMemberMetaData().getAbsoluteFieldNumber());
        } else {
            joinTable.getOwnerMapping().setObject(ec, ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)joinTable.getOwnerMapping()), sm.getObject());
        }
        return jdbcPosition + joinTable.getOwnerMapping().getNumberOfDatastoreMappings();
    }
}

