/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.type;

import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionType
extends JavaType {
    final JavaType _elementType;
    final boolean _fullyTyped;

    private CollectionType(Class<?> collT, JavaType elemT, boolean fullyTyped) {
        super(collT);
        this._elementType = elemT;
        this._hashCode += elemT.hashCode();
        this._fullyTyped = fullyTyped;
    }

    @Override
    protected JavaType _narrow(Class<?> subclass) {
        return new CollectionType(subclass, this._elementType, this._fullyTyped);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> contentClass) {
        if (contentClass == this._elementType.getRawClass()) {
            return this;
        }
        JavaType newElementType = this._elementType.narrowBy(contentClass);
        return new CollectionType(this._class, newElementType, this._fullyTyped);
    }

    public static CollectionType untyped(Class<?> rawType, JavaType elemT) {
        return new CollectionType(rawType, elemT, false);
    }

    public static CollectionType typed(Class<?> rawType, JavaType elemT) {
        return new CollectionType(rawType, elemT, elemT.isFullyTyped());
    }

    @Override
    public boolean isFullyTyped() {
        return this._fullyTyped;
    }

    public JavaType getElementType() {
        return this._elementType;
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public String toString() {
        return "[collection type for " + this._elementType + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        CollectionType other = (CollectionType)o;
        return this._elementType.equals(other._elementType);
    }
}

