/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.agent.commons.EventStreamDefinition;
import org.wso2.carbon.agent.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.agent.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.agent.commons.utils.EventConverter;
import org.wso2.carbon.agent.server.AgentCallback;
import org.wso2.carbon.agent.server.datastore.StreamDefinitionStore;
import org.wso2.carbon.agent.server.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.agent.server.internal.EventStreamTypeHolder;
import org.wso2.carbon.agent.server.internal.authentication.session.AgentSession;
import org.wso2.carbon.agent.server.internal.queue.EventQueue;
import org.wso2.carbon.agent.server.internal.utils.EventComposite;

public class EventDispatcher {
    private List<AgentCallback> subscribers = new ArrayList<AgentCallback>();
    private StreamDefinitionStore streamDefinitionStore;
    private Map<String, EventStreamTypeHolder> eventStreamTypeCache = new HashMap<String, EventStreamTypeHolder>();
    private EventQueue eventQueue = new EventQueue(this.subscribers);

    public EventDispatcher(StreamDefinitionStore streamDefinitionStore) {
        this.streamDefinitionStore = streamDefinitionStore;
    }

    public void addCallback(AgentCallback agentCallback) {
        this.subscribers.add(agentCallback);
    }

    public String defineEventStream(String streamDefinition, AgentSession agentSession) throws MalformedStreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException {
        EventStreamDefinition eventStreamDefinition = EventConverter.convertFromJson((String)streamDefinition);
        try {
            EventStreamDefinition existingEventStreamDefinition = this.streamDefinitionStore.getStreamDefinition(agentSession.getDomainName(), eventStreamDefinition.getName(), eventStreamDefinition.getVersion());
            if (!existingEventStreamDefinition.equals((Object)eventStreamDefinition)) {
                throw new DifferentStreamDefinitionAlreadyDefinedException("Similar event stream for " + eventStreamDefinition + " with the same name and version already exist: " + this.streamDefinitionStore.getStreamDefinition(agentSession.getDomainName(), eventStreamDefinition.getName(), eventStreamDefinition.getVersion()));
            }
            eventStreamDefinition = existingEventStreamDefinition;
        }
        catch (StreamDefinitionNotFoundException e) {
            this.streamDefinitionStore.saveStreamDefinition(agentSession.getDomainName(), eventStreamDefinition);
            this.updateEventStreamTypeCache(agentSession.getDomainName(), eventStreamDefinition);
        }
        for (AgentCallback agentCallback : this.subscribers) {
            agentCallback.definedEventStream(eventStreamDefinition, agentSession.getUsername(), agentSession.getPassword(), agentSession.getDomainName());
        }
        return eventStreamDefinition.getStreamId();
    }

    private void updateEventStreamTypeCache(String domainName, EventStreamDefinition eventStreamDefinition) {
        EventStreamTypeHolder eventStreamTypeHolder;
        if (this.eventStreamTypeCache.containsKey(domainName)) {
            eventStreamTypeHolder = this.eventStreamTypeCache.get(domainName);
        } else {
            eventStreamTypeHolder = new EventStreamTypeHolder(domainName);
            this.eventStreamTypeCache.put(domainName, eventStreamTypeHolder);
        }
        this.updateEventStreamTypeHolder(eventStreamTypeHolder, eventStreamDefinition);
    }

    public void publish(Object eventBundle, AgentSession agentSession) throws UndefinedEventTypeException {
        try {
            this.eventQueue.publish(new EventComposite(eventBundle, this.getStreamDefinitionHolder(agentSession.getDomainName()), agentSession));
        }
        catch (StreamDefinitionNotFoundException e) {
            throw new UndefinedEventTypeException("No event stream definition exist " + e.getErrorMessage());
        }
    }

    private EventStreamTypeHolder getStreamDefinitionHolder(String domainName) throws StreamDefinitionNotFoundException {
        EventStreamTypeHolder eventStreamTypeHolder = this.eventStreamTypeCache.get(domainName);
        if (eventStreamTypeHolder != null) {
            return eventStreamTypeHolder;
        }
        eventStreamTypeHolder = new EventStreamTypeHolder(domainName);
        for (EventStreamDefinition eventStreamDefinition : this.streamDefinitionStore.getAllStreamDefinitions(domainName)) {
            this.updateEventStreamTypeHolder(eventStreamTypeHolder, eventStreamDefinition);
        }
        return eventStreamTypeHolder;
    }

    private void updateEventStreamTypeHolder(EventStreamTypeHolder eventStreamTypeHolder, EventStreamDefinition eventStreamDefinition) {
        eventStreamTypeHolder.setMetaDataType(eventStreamDefinition.getStreamId(), EventConverter.generateAttributeTypeArray((List)eventStreamDefinition.getMetaData()));
        eventStreamTypeHolder.setCorrelationDataType(eventStreamDefinition.getStreamId(), EventConverter.generateAttributeTypeArray((List)eventStreamDefinition.getCorrelationData()));
        eventStreamTypeHolder.setPayloadDataType(eventStreamDefinition.getStreamId(), EventConverter.generateAttributeTypeArray((List)eventStreamDefinition.getPayloadData()));
    }

    public List<AgentCallback> getSubscribers() {
        return this.subscribers;
    }

    public String findEventStreamId(String domainName, String streamName, String streamVersion) throws StreamDefinitionNotFoundException {
        try {
            return this.streamDefinitionStore.getStreamId(domainName, streamName, streamVersion);
        }
        catch (StreamDefinitionNotFoundException e) {
            throw new StreamDefinitionNotFoundException("No event stream definition exist " + e.getErrorMessage());
        }
    }
}

