/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.commons.EventStreamDefinition;
import org.wso2.carbon.agent.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.agent.commons.utils.EventConverter;
import org.wso2.carbon.agent.exception.TransportException;
import org.wso2.carbon.agent.server.AgentCallback;
import org.wso2.carbon.agent.server.AgentServer;
import org.wso2.carbon.agent.server.conf.AgentServerConfiguration;
import org.wso2.carbon.agent.server.datastore.StreamDefinitionStore;
import org.wso2.carbon.agent.server.exception.AgentServerException;
import org.wso2.carbon.agent.server.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.agent.server.internal.EventDispatcher;
import org.wso2.carbon.agent.server.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.agent.server.internal.authentication.Authenticator;
import org.wso2.carbon.base.ServerConfiguration;

public abstract class AbstractAgentServer
implements AgentServer {
    private static final Log log = LogFactory.getLog(AbstractAgentServer.class);
    private EventDispatcher eventDispatcher;
    private AgentServerConfiguration agentServerConfiguration;
    private StreamDefinitionStore streamDefinitionStore;

    public AbstractAgentServer(int secureReceiverPort, int receiverPort, AuthenticationHandler authenticationHandler, StreamDefinitionStore streamDefinitionStore) {
        this.streamDefinitionStore = streamDefinitionStore;
        Authenticator.getInstance().init(authenticationHandler);
        this.eventDispatcher = new EventDispatcher(streamDefinitionStore);
        this.agentServerConfiguration = new AgentServerConfiguration(secureReceiverPort, receiverPort);
    }

    public AbstractAgentServer(int receiverPort, AuthenticationHandler authenticationHandler, StreamDefinitionStore streamDefinitionStore) {
        this.streamDefinitionStore = streamDefinitionStore;
        Authenticator.getInstance().init(authenticationHandler);
        this.eventDispatcher = new EventDispatcher(streamDefinitionStore);
        this.agentServerConfiguration = new AgentServerConfiguration(receiverPort + 100, receiverPort);
    }

    public AbstractAgentServer(AgentServerConfiguration agentServerConfiguration, AuthenticationHandler authenticationHandler, StreamDefinitionStore streamDefinitionStore) {
        this.streamDefinitionStore = streamDefinitionStore;
        Authenticator.getInstance().init(authenticationHandler);
        this.eventDispatcher = new EventDispatcher(streamDefinitionStore);
        this.agentServerConfiguration = agentServerConfiguration;
    }

    @Override
    public void subscribe(AgentCallback agentCallback) {
        this.eventDispatcher.addCallback(agentCallback);
    }

    @Override
    public EventStreamDefinition getStreamDefinition(String domainName, String streamName, String streamVersion) throws StreamDefinitionNotFoundException {
        return this.streamDefinitionStore.getStreamDefinition(domainName, streamName, streamVersion);
    }

    @Override
    public EventStreamDefinition getStreamDefinition(String domainName, String streamId) throws StreamDefinitionNotFoundException {
        return this.streamDefinitionStore.getStreamDefinition(domainName, streamId);
    }

    @Override
    public List<EventStreamDefinition> getAllStreamDefinition(String domainName) throws StreamDefinitionNotFoundException {
        return new ArrayList<EventStreamDefinition>(this.streamDefinitionStore.getAllStreamDefinitions(domainName));
    }

    @Override
    public void saveEventStreamDefinition(String domainName, String eventStreamDefinition) throws MalformedStreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException {
        this.streamDefinitionStore.saveStreamDefinition(domainName, EventConverter.convertFromJson((String)eventStreamDefinition));
    }

    public void start(String hostName) throws AgentServerException {
        this.startSecureEventTransmission(hostName, this.agentServerConfiguration.getSecureEventReceiverPort(), this.eventDispatcher);
        this.startEventTransmission(this.agentServerConfiguration.getEventReceiverPort(), this.eventDispatcher);
    }

    protected abstract void startEventTransmission(int var1, EventDispatcher var2) throws AgentServerException;

    private void startSecureEventTransmission(String hostName, int port, EventDispatcher eventDispatcher) throws AgentServerException {
        try {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String keyStore = serverConfig.getFirstProperty("Security.KeyStore.Location");
            if (keyStore == null && (keyStore = System.getProperty("Security.KeyStore.Location")) == null) {
                throw new AgentServerException("Cannot start agent server, not valid Security.KeyStore.Location is null");
            }
            String keyStorePassword = serverConfig.getFirstProperty("Security.KeyStore.Password");
            if (keyStorePassword == null && (keyStorePassword = System.getProperty("Security.KeyStore.Password")) == null) {
                throw new AgentServerException("Cannot start agent server, not valid Security.KeyStore.Password is null ");
            }
            this.startSecureEventTransmission(hostName, port, keyStore, keyStorePassword, eventDispatcher);
        }
        catch (TransportException e) {
            throw new AgentServerException("Cannot start agent server on port " + port, e);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
    }

    protected abstract void startSecureEventTransmission(String var1, int var2, String var3, String var4, EventDispatcher var5) throws AgentServerException, TransportException, UnknownHostException;

    public List<AgentCallback> getSubscribers() {
        return this.eventDispatcher.getSubscribers();
    }

    public abstract void stop();
}

