/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.datastore;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.agent.commons.EventStreamDefinition;
import org.wso2.carbon.agent.server.datastore.StreamDefinitionStore;

public class InMemoryStreamDefinitionStore
extends StreamDefinitionStore {
    private Map<String, HashMap<String, EventStreamDefinition>> streamDefinitionStore = new HashMap<String, HashMap<String, EventStreamDefinition>>();
    private Map<String, HashMap<String, String>> streamIdStore = new HashMap<String, HashMap<String, String>>();

    @Override
    protected void saveStreamIdToStore(String domainName, String streamIdKey, String streamId) {
        if (!this.streamIdStore.containsKey(domainName)) {
            this.streamIdStore.put(domainName, new HashMap());
        }
        this.streamIdStore.get(domainName).put(streamIdKey, streamId);
    }

    @Override
    protected void saveStreamDefinitionToStore(String domainName, String streamId, EventStreamDefinition streamDefinition) {
        if (!this.streamDefinitionStore.containsKey(domainName)) {
            this.streamDefinitionStore.put(domainName, new HashMap());
        }
        this.streamDefinitionStore.get(domainName).put(streamId, streamDefinition);
    }

    @Override
    protected String getStreamIdFromStore(String domainName, String streamIdKey) {
        if (this.streamIdStore.get(domainName) != null) {
            return this.streamIdStore.get(domainName).get(streamIdKey);
        }
        return null;
    }

    @Override
    public EventStreamDefinition getStreamDefinitionFromStore(String domainName, String streamId) {
        if (this.streamDefinitionStore.get(domainName) != null) {
            return this.streamDefinitionStore.get(domainName).get(streamId);
        }
        return null;
    }

    @Override
    public Collection<EventStreamDefinition> getAllStreamDefinitionsFromStore(String domainName) {
        HashMap<String, EventStreamDefinition> map = this.streamDefinitionStore.get(domainName);
        if (map != null) {
            return map.values();
        }
        return null;
    }
}

