/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.internal.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.conf.AgentConfiguration;
import org.wso2.carbon.agent.exception.AgentConfigurationException;

public final class AgentBuilder {
    private static final Log log = LogFactory.getLog(AgentBuilder.class);

    private AgentBuilder() {
    }

    public static AgentConfiguration loadAgentConfiguration() throws AgentConfigurationException {
        OMElement agentConfig = AgentBuilder.loadConfigXML();
        if (agentConfig != null) {
            if (!agentConfig.getQName().equals(new QName("http://wso2.org/carbon/agent", "agentConfiguration"))) {
                throw new AgentConfigurationException("Invalid root element in agent server config");
            }
            return AgentBuilder.buildAgentConfiguration(agentConfig);
        }
        throw new AgentConfigurationException("Invalid agent config");
    }

    private static OMElement loadConfigXML() throws AgentConfigurationException {
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "agent-config.xml";
        File agentConfigFile = new File(path);
        if (!agentConfigFile.exists()) {
            return null;
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            String errorMessage = "agent-config.xmlcannot be found in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
            throw new AgentConfigurationException(errorMessage, e);
        }
        catch (XMLStreamException e) {
            String errorMessage = "Invalid XML for agent-config.xml located in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
            throw new AgentConfigurationException(errorMessage, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                String errorMessage = "Can not close the input stream";
                log.error((Object)errorMessage, (Throwable)e);
                throw new AgentConfigurationException(errorMessage, e);
            }
        }
    }

    private static AgentConfiguration buildAgentConfiguration(OMElement agentServerConfig) {
        AgentConfiguration agentConfiguration = new AgentConfiguration();
        AgentBuilder.buildReceiverConfiguration(agentServerConfig, agentConfiguration);
        AgentBuilder.buildKeyStoreConfiguration(agentServerConfig, agentConfiguration);
        return agentConfiguration;
    }

    private static void buildReceiverConfiguration(OMElement agentServerConfig, AgentConfiguration agentConfiguration) {
        OMElement secureMinIdleTimeInPool;
        OMElement secureMaxTransportPoolSize;
        OMElement secureMaxIdleConnections;
        OMElement secureEvictionTimePeriod;
        OMElement evictionTimePeriod;
        OMElement poolSize;
        OMElement bufferedEventsSize;
        OMElement minIdleTimeInPool;
        OMElement maxMessageBundleSize;
        OMElement maxIdleConnections;
        OMElement maxTransportPoolSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "maxTransportPoolSize"));
        if (maxTransportPoolSize != null) {
            agentConfiguration.setMaxTransportPoolSize(Integer.parseInt(maxTransportPoolSize.getText()));
        }
        if ((maxIdleConnections = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "maxIdleConnections"))) != null) {
            agentConfiguration.setMaxIdleConnections(Integer.parseInt(maxIdleConnections.getText()));
        }
        if ((maxMessageBundleSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "maxMessageBundleSize"))) != null) {
            agentConfiguration.setMaxMessageBundleSize(Integer.parseInt(maxMessageBundleSize.getText()));
        }
        if ((minIdleTimeInPool = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "minIdleTimeInPool"))) != null) {
            agentConfiguration.setMinIdleTimeInPool(Integer.parseInt(minIdleTimeInPool.getText()));
        }
        if ((bufferedEventsSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "bufferedEventsSize"))) != null) {
            agentConfiguration.setBufferedEventsSize(Integer.parseInt(bufferedEventsSize.getText()));
        }
        if ((poolSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "poolSize"))) != null) {
            agentConfiguration.setPoolSize(Integer.parseInt(poolSize.getText()));
        }
        if ((evictionTimePeriod = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "evictionTimePeriod"))) != null) {
            agentConfiguration.setEvictionTimePeriod(Integer.parseInt(evictionTimePeriod.getText()));
        }
        if ((secureEvictionTimePeriod = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "secureEvictionTimePeriod"))) != null) {
            agentConfiguration.setSecureEvictionTimePeriod(Integer.parseInt(secureEvictionTimePeriod.getText()));
        }
        if ((secureMaxIdleConnections = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "secureMaxIdleConnections"))) != null) {
            agentConfiguration.setEvictionTimePeriod(Integer.parseInt(secureMaxIdleConnections.getText()));
        }
        if ((secureMaxTransportPoolSize = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "secureMaxTransportPoolSize"))) != null) {
            agentConfiguration.setEvictionTimePeriod(Integer.parseInt(secureMaxTransportPoolSize.getText()));
        }
        if ((secureMinIdleTimeInPool = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "secureMinIdleTimeInPool"))) != null) {
            agentConfiguration.setEvictionTimePeriod(Integer.parseInt(secureMinIdleTimeInPool.getText()));
        }
    }

    private static void buildKeyStoreConfiguration(OMElement agentServerConfig, AgentConfiguration agentConfiguration) {
        OMElement trustStorePassword;
        OMElement trustStore = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "trustStore"));
        if (trustStore != null) {
            agentConfiguration.setTrustStore(trustStore.getText());
        }
        if ((trustStorePassword = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "trustStorePassword"))) != null) {
            agentConfiguration.setTrustStorePassword(trustStorePassword.getText());
        }
    }
}

