/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.wso2.carbon.agent.DataPublisher;
import org.wso2.carbon.agent.conf.AgentConfiguration;
import org.wso2.carbon.agent.internal.pool.client.general.ClientPool;
import org.wso2.carbon.agent.internal.pool.client.general.ClientPoolFactory;
import org.wso2.carbon.agent.internal.pool.client.secure.SecureClientPool;
import org.wso2.carbon.agent.internal.pool.client.secure.SecureClientPoolFactory;
import org.wso2.carbon.agent.internal.publisher.authenticator.AgentAuthenticator;
import org.wso2.carbon.agent.internal.publisher.authenticator.AgentAuthenticatorFactory;

public class Agent {
    private static Log log = LogFactory.getLog(Agent.class);
    private AgentConfiguration agentConfiguration;
    private GenericKeyedObjectPool transportPool;
    private Semaphore queueSemaphore;
    private AgentAuthenticator agentAuthenticator;
    private List<DataPublisher> dataPublisherList;
    private ThreadPoolExecutor threadPool;
    private GenericKeyedObjectPool secureTransportPool;

    public Agent() {
        this(new AgentConfiguration());
    }

    public Agent(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        this.transportPool = new ClientPool().getClientPool((KeyedPoolableObjectFactory)new ClientPoolFactory(), agentConfiguration.getMaxTransportPoolSize(), agentConfiguration.getMaxIdleConnections(), true, agentConfiguration.getEvictionTimePeriod(), agentConfiguration.getMinIdleTimeInPool());
        this.secureTransportPool = new SecureClientPool().getClientPool((KeyedPoolableObjectFactory)new SecureClientPoolFactory(agentConfiguration.getTrustStore(), agentConfiguration.getTrustStorePassword()), agentConfiguration.getSecureMaxTransportPoolSize(), agentConfiguration.getSecureMaxIdleConnections(), true, agentConfiguration.getSecureEvictionTimePeriod(), agentConfiguration.getSecureMinIdleTimeInPool());
        this.agentAuthenticator = AgentAuthenticatorFactory.getAgentAuthenticator(this.secureTransportPool);
        this.dataPublisherList = new LinkedList<DataPublisher>();
        this.queueSemaphore = new Semaphore(agentConfiguration.getBufferedEventsSize());
        this.threadPool = new ThreadPoolExecutor(agentConfiguration.getPoolSize(), Integer.MAX_VALUE, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    void addDataPublisher(DataPublisher dataPublisher) {
        this.dataPublisherList.add(dataPublisher);
    }

    void removeDataPublisher(DataPublisher dataPublisher) {
        this.dataPublisherList.remove(dataPublisher);
    }

    synchronized void shutdown(DataPublisher dataPublisher) {
        this.removeDataPublisher(dataPublisher);
        if (this.dataPublisherList.size() == 0) {
            this.shutdown();
        }
    }

    public void shutdown() {
        try {
            this.transportPool.close();
            this.threadPool.shutdown();
        }
        catch (Exception e) {
            log.warn((Object)"Agent shutdown failed");
        }
    }

    public AgentConfiguration getAgentConfiguration() {
        return this.agentConfiguration;
    }

    public GenericKeyedObjectPool getTransportPool() {
        return this.transportPool;
    }

    public Semaphore getQueueSemaphore() {
        return this.queueSemaphore;
    }

    public AgentAuthenticator getAgentAuthenticator() {
        return this.agentAuthenticator;
    }

    List<DataPublisher> getDataPublisherList() {
        return this.dataPublisherList;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public GenericKeyedObjectPool getSecureTransportPool() {
        return this.secureTransportPool;
    }
}

