/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.service.general;

import org.apache.thrift.TException;
import org.wso2.carbon.agent.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.agent.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.agent.commons.exception.SessionTimeoutException;
import org.wso2.carbon.agent.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.agent.commons.thrift.data.ThriftEventBundle;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftDifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftMalformedStreamDefinitionException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftNoStreamDefinitionExistException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftSessionExpiredException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftUndefinedEventTypeException;
import org.wso2.carbon.agent.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.agent.server.internal.EventDispatcher;
import org.wso2.carbon.agent.server.internal.service.general.EventReceiverService;

public class ThriftEventTransmissionServiceImpl
implements ThriftEventTransmissionService.Iface {
    private EventReceiverService eventReceiverService;

    public ThriftEventTransmissionServiceImpl(EventDispatcher eventDispatcher) {
        this.eventReceiverService = new EventReceiverService(eventDispatcher);
    }

    public String defineEventStream(String sessionId, String streamDefinition) throws TException, ThriftSessionExpiredException, ThriftDifferentStreamDefinitionAlreadyDefinedException, ThriftMalformedStreamDefinitionException {
        try {
            return this.eventReceiverService.defineEventStream(sessionId, streamDefinition);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new ThriftDifferentStreamDefinitionAlreadyDefinedException(e.getErrorMessage());
        }
        catch (MalformedStreamDefinitionException e) {
            throw new ThriftMalformedStreamDefinitionException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }

    public String findEventStreamId(String sessionId, String streamName, String streamVersion) throws ThriftNoStreamDefinitionExistException, ThriftSessionExpiredException, TException {
        try {
            return this.eventReceiverService.findEventStreamId(sessionId, streamName, streamVersion);
        }
        catch (NoStreamDefinitionExistException e) {
            throw new ThriftNoStreamDefinitionExistException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }

    public void publish(ThriftEventBundle eventBundle) throws ThriftUndefinedEventTypeException, ThriftSessionExpiredException, TException {
        try {
            this.eventReceiverService.publish(eventBundle, eventBundle.getSessionId());
        }
        catch (UndefinedEventTypeException e) {
            throw new ThriftUndefinedEventTypeException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }
}

