/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.service.general;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.agent.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.agent.commons.exception.SessionTimeoutException;
import org.wso2.carbon.agent.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.agent.server.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.agent.server.internal.EventDispatcher;
import org.wso2.carbon.agent.server.internal.authentication.Authenticator;
import org.wso2.carbon.agent.server.internal.authentication.session.AgentSession;

public class EventReceiverService {
    private EventDispatcher eventDispatcher;
    private static final Log log = LogFactory.getLog(Authenticator.class);

    public EventReceiverService(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public String defineEventStream(String sessionId, String streamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, SessionTimeoutException {
        AgentSession agentSession = Authenticator.getInstance().getSession(sessionId);
        if (agentSession.getUsername() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            return this.eventDispatcher.defineEventStream(streamDefinition, agentSession);
        }
        catch (MalformedStreamDefinitionException e) {
            throw new MalformedStreamDefinitionException(e.getErrorMessage(), (Throwable)e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new DifferentStreamDefinitionAlreadyDefinedException(e.getErrorMessage(), (Throwable)e);
        }
    }

    public String findEventStreamId(String sessionId, String streamName, String streamVersion) throws NoStreamDefinitionExistException, SessionTimeoutException {
        AgentSession agentSession = Authenticator.getInstance().getSession(sessionId);
        if (agentSession.getUsername() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            return this.eventDispatcher.findEventStreamId(agentSession.getDomainName(), streamName, streamVersion);
        }
        catch (StreamDefinitionNotFoundException e) {
            throw new NoStreamDefinitionExistException(e.getErrorMessage(), (Throwable)e);
        }
    }

    public void publish(Object eventBundle, String sessionId) throws UndefinedEventTypeException, SessionTimeoutException {
        AgentSession agentSession = Authenticator.getInstance().getSession(sessionId);
        if (agentSession.getUsername() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        this.eventDispatcher.publish(eventBundle, agentSession);
    }
}

