/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.queue;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.commons.Event;
import org.wso2.carbon.agent.server.AgentCallback;
import org.wso2.carbon.agent.server.exception.EventConversionException;
import org.wso2.carbon.agent.server.internal.utils.EventComposite;
import org.wso2.carbon.agent.server.internal.utils.ThriftEventConverter;

public class QueueWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(QueueWorker.class);
    private BlockingQueue<EventComposite> eventQueue;
    private List<AgentCallback> subscribers;

    public QueueWorker(BlockingQueue<EventComposite> queue, List<AgentCallback> subscribers) {
        this.eventQueue = queue;
        this.subscribers = subscribers;
    }

    @Override
    public void run() {
        List<Event> eventList = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.eventQueue.size() + " messages in queue before " + Thread.currentThread().getName() + " worker has polled queue"));
            }
            EventComposite eventComposite = (EventComposite)this.eventQueue.poll();
            try {
                eventList = ThriftEventConverter.createEventList(eventComposite.getEventBundle(), eventComposite.getEventStreamTypeHolder());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dispatching event to " + this.subscribers.size() + " subscriber(s)"));
                }
                for (AgentCallback agentCallback : this.subscribers) {
                    agentCallback.receive(eventList, eventComposite.getAgentSession().getUsername(), eventComposite.getAgentSession().getPassword(), eventComposite.getAgentSession().getDomainName());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.eventQueue.size() + " messages in queue after " + Thread.currentThread().getName() + " worker has finished work"));
                }
            }
            catch (EventConversionException re) {
                log.error((Object)("Wrongly formatted event sent for " + eventComposite.getEventStreamTypeHolder().getDomainName()), (Throwable)re);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)("Error in passing events " + eventList + " to subscribers " + this.subscribers), (Throwable)e);
        }
    }
}

