/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.authentication.session;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.wso2.carbon.agent.server.internal.authentication.session.AgentSession;

public class SessionCache {
    private ConcurrentMap<String, AgentSession> sessionCache;

    public SessionCache(int expirationTimeInMinutes) {
        this.sessionCache = new MapMaker().expiration((long)expirationTimeInMinutes, TimeUnit.MINUTES).makeComputingMap((Function)new SessionFunction());
    }

    public AgentSession getSession(String sessionId) {
        return (AgentSession)this.sessionCache.get(sessionId);
    }

    public void removeSession(String sessionId) {
        this.sessionCache.remove(sessionId);
    }

    static class SessionFunction
    implements Function<String, AgentSession> {
        SessionFunction() {
        }

        public AgentSession apply(@Nullable String sessionId) {
            return new AgentSession(sessionId);
        }
    }
}

