/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.agent.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.agent.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.agent.exception.TransportException;
import org.wso2.carbon.agent.server.conf.AgentServerConfiguration;
import org.wso2.carbon.agent.server.datastore.StreamDefinitionStore;
import org.wso2.carbon.agent.server.exception.AgentServerException;
import org.wso2.carbon.agent.server.internal.AbstractAgentServer;
import org.wso2.carbon.agent.server.internal.EventDispatcher;
import org.wso2.carbon.agent.server.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.agent.server.internal.service.general.ThriftEventTransmissionServiceImpl;
import org.wso2.carbon.agent.server.internal.service.secure.ThriftSecureEventTransmissionServiceImpl;

public class ThriftAgentServer
extends AbstractAgentServer {
    private static Log log = LogFactory.getLog(ThriftAgentServer.class);
    private TServer authenticationServer;
    private TServer eventReceiverServer;

    public ThriftAgentServer(int secureReceiverPort, int receiverPort, AuthenticationHandler authenticationHandler, StreamDefinitionStore streamDefinitionStore) {
        super(secureReceiverPort, receiverPort, authenticationHandler, streamDefinitionStore);
    }

    public ThriftAgentServer(int receiverPort, AuthenticationHandler authenticationHandler, StreamDefinitionStore streamDefinitionStore) {
        super(receiverPort, authenticationHandler, streamDefinitionStore);
    }

    public ThriftAgentServer(AgentServerConfiguration agentServerConfiguration, AuthenticationHandler authenticationHandler, StreamDefinitionStore streamDefinitionStore) {
        super(agentServerConfiguration, authenticationHandler, streamDefinitionStore);
    }

    @Override
    protected void startSecureEventTransmission(String hostName, int port, String keyStore, String keyStorePassword, EventDispatcher eventDispatcher) throws TransportException, UnknownHostException {
        TServerSocket serverTransport;
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(keyStore, keyStorePassword);
        try {
            serverTransport = TSSLTransportFactory.getServerSocket((int)port, (int)30000, (InetAddress)InetAddress.getByName(hostName), (TSSLTransportFactory.TSSLTransportParameters)params);
        }
        catch (TTransportException e) {
            throw new TransportException("Thrift transport exception occurred ", (Throwable)e);
        }
        ThriftSecureEventTransmissionService.Processor processor = new ThriftSecureEventTransmissionService.Processor((ThriftSecureEventTransmissionService.Iface)new ThriftSecureEventTransmissionServiceImpl(eventDispatcher));
        this.authenticationServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor));
        Thread thread = new Thread(new ServerThread(this.authenticationServer));
        log.info((Object)("Thrift SSL port : " + port));
        thread.start();
    }

    @Override
    protected void startEventTransmission(int port, EventDispatcher eventDispatcher) throws AgentServerException {
        try {
            TServerSocket serverTransport = new TServerSocket(port);
            ThriftEventTransmissionService.Processor processor = new ThriftEventTransmissionService.Processor((ThriftEventTransmissionService.Iface)new ThriftEventTransmissionServiceImpl(eventDispatcher));
            this.eventReceiverServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor));
            Thread thread = new Thread(new ServerThread(this.eventReceiverServer));
            log.info((Object)("Thrift port : " + port));
            thread.start();
        }
        catch (TTransportException e) {
            throw new AgentServerException("Cannot start Thrift server on port " + port, e);
        }
    }

    @Override
    public void stop() {
        this.authenticationServer.stop();
        this.eventReceiverServer.stop();
    }

    static class ServerThread
    implements Runnable {
        private TServer server;

        ServerThread(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }
}

