/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.datastore;

import java.util.Collection;
import org.wso2.carbon.agent.commons.EventStreamDefinition;
import org.wso2.carbon.agent.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.utils.EventConverter;
import org.wso2.carbon.agent.server.exception.StreamDefinitionNotFoundException;

public abstract class StreamDefinitionStore {
    private String constructNameVersionKey(String name, String version) {
        return name + "::" + version;
    }

    public EventStreamDefinition getStreamDefinition(String domainName, String name, String version) throws StreamDefinitionNotFoundException {
        String streamId = this.getStreamIdFromStore(domainName, this.constructNameVersionKey(name, version));
        if (streamId == null) {
            throw new StreamDefinitionNotFoundException("No definitions exist on " + domainName + " for " + this.constructNameVersionKey(name, version));
        }
        return this.getStreamDefinition(domainName, streamId);
    }

    public EventStreamDefinition getStreamDefinition(String domainName, String streamId) throws StreamDefinitionNotFoundException {
        EventStreamDefinition eventStreamDefinition = this.getStreamDefinitionFromStore(domainName, streamId);
        if (eventStreamDefinition == null) {
            throw new StreamDefinitionNotFoundException("No definitions exist on " + domainName + " for " + streamId);
        }
        return eventStreamDefinition;
    }

    public void saveStreamDefinition(String domainName, EventStreamDefinition eventStreamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException {
        EventStreamDefinition existingDefinition = null;
        try {
            existingDefinition = this.getStreamDefinition(domainName, eventStreamDefinition.getName(), eventStreamDefinition.getVersion());
        }
        catch (StreamDefinitionNotFoundException e) {
            this.saveStreamIdToStore(domainName, this.constructNameVersionKey(eventStreamDefinition.getName(), eventStreamDefinition.getVersion()), eventStreamDefinition.getStreamId());
            this.saveStreamDefinitionToStore(domainName, eventStreamDefinition.getStreamId(), eventStreamDefinition);
            return;
        }
        if (!existingDefinition.equals((Object)eventStreamDefinition)) {
            throw new DifferentStreamDefinitionAlreadyDefinedException("Another Stream with same name and version exist :" + EventConverter.convertToJson((EventStreamDefinition)existingDefinition));
        }
    }

    public Collection<EventStreamDefinition> getAllStreamDefinitions(String domainName) {
        return this.getAllStreamDefinitionsFromStore(domainName);
    }

    public String getStreamId(String domainName, String streamName, String streamVersion) throws StreamDefinitionNotFoundException {
        String streamId = this.getStreamIdFromStore(domainName, this.constructNameVersionKey(streamName, streamVersion));
        if (streamId == null) {
            throw new StreamDefinitionNotFoundException("No stream id found for " + streamId + " " + streamVersion);
        }
        return streamId;
    }

    protected abstract void saveStreamIdToStore(String var1, String var2, String var3);

    protected abstract void saveStreamDefinitionToStore(String var1, String var2, EventStreamDefinition var3);

    protected abstract String getStreamIdFromStore(String var1, String var2);

    public abstract EventStreamDefinition getStreamDefinitionFromStore(String var1, String var2);

    protected abstract Collection<EventStreamDefinition> getAllStreamDefinitionsFromStore(String var1);
}

