/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.server.conf.AgentServerConfiguration;
import org.wso2.carbon.agent.server.exception.AgentServerConfigurationException;
import org.wso2.carbon.base.api.ServerConfigurationService;

public final class AgentServerBuilder {
    private static final Log log = LogFactory.getLog(AgentServerBuilder.class);

    private AgentServerBuilder() {
    }

    private static OMElement loadConfigXML() throws AgentServerConfigurationException {
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "agent-server-config.xml";
        File agentServerConfigFile = new File(path);
        if (!agentServerConfigFile.exists()) {
            return null;
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            String errorMessage = "agent-server-config.xmlcannot be found in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
            throw new AgentServerConfigurationException(errorMessage, e);
        }
        catch (XMLStreamException e) {
            String errorMessage = "Invalid XML for agent-server-config.xml located in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
            throw new AgentServerConfigurationException(errorMessage, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                String errorMessage = "Can not close the input stream";
                log.error((Object)errorMessage, (Throwable)e);
            }
        }
    }

    private static void populateEventStreamDefinitions(OMElement agentServerConfig, List<String[]> eventStreamDefinitionList) {
        OMElement eventStreamDefinitions = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "eventStreamDefinitions"));
        if (eventStreamDefinitions != null) {
            Iterator eventStreamDefinitionIterator = eventStreamDefinitions.getChildElements();
            while (eventStreamDefinitionIterator.hasNext()) {
                OMElement eventStreamDefinition = (OMElement)eventStreamDefinitionIterator.next();
                String domainName = eventStreamDefinition.getAttributeValue(new QName("domainName"));
                eventStreamDefinitionList.add(new String[]{domainName, eventStreamDefinition.getText()});
            }
        }
    }

    private static void populatePorts(OMElement agentServerConfig, ServerConfigurationService serverConfiguration, AgentServerConfiguration agentServerConfiguration) {
        OMElement receiverPort;
        int portOffSet = AgentServerBuilder.readPortOffset(serverConfiguration);
        OMElement secureEventReceiverPort = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "secureEventReceiverPort"));
        if (secureEventReceiverPort != null) {
            agentServerConfiguration.setSecureEventReceiverPort(Integer.parseInt(secureEventReceiverPort.getText()) + portOffSet);
        }
        if ((receiverPort = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "eventReceiverPort"))) != null) {
            agentServerConfiguration.setEventReceiverPort(Integer.parseInt(receiverPort.getText()) + portOffSet);
        }
    }

    private static void populateStreamDefinitionStore(OMElement agentServerConfig, AgentServerConfiguration agentServerConfiguration) {
        OMElement streamDefinitionStore = agentServerConfig.getFirstChildWithName(new QName("http://wso2.org/carbon/agent", "StreamDefinitionStore"));
        if (streamDefinitionStore != null) {
            agentServerConfiguration.setStreamDefinitionStoreName(streamDefinitionStore.getText());
        }
    }

    private static int readPortOffset(ServerConfigurationService serverConfiguration) {
        String portOffset = serverConfiguration.getFirstProperty("Ports.Offset");
        try {
            return portOffset != null ? Integer.parseInt(portOffset.trim()) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static void populateConfigurations(ServerConfigurationService serverConfiguration, AgentServerConfiguration agentServerConfiguration, List<String[]> eventStreamDefinitions) throws AgentServerConfigurationException {
        OMElement agentServerConfig = AgentServerBuilder.loadConfigXML();
        if (agentServerConfig != null) {
            if (!agentServerConfig.getQName().equals(new QName("http://wso2.org/carbon/agent", "agentServerConfiguration"))) {
                throw new AgentServerConfigurationException("Invalid root element in agent server config");
            }
            AgentServerBuilder.populatePorts(agentServerConfig, serverConfiguration, agentServerConfiguration);
            AgentServerBuilder.populateEventStreamDefinitions(agentServerConfig, eventStreamDefinitions);
            AgentServerBuilder.populateStreamDefinitionStore(agentServerConfig, agentServerConfiguration);
        }
    }
}

