/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.service.secure;

import org.apache.thrift.TException;
import org.wso2.carbon.agent.commons.exception.AuthenticationException;
import org.wso2.carbon.agent.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.agent.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.agent.commons.exception.SessionTimeoutException;
import org.wso2.carbon.agent.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.agent.commons.thrift.data.ThriftEventBundle;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftAuthenticationException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftDifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftMalformedStreamDefinitionException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftNoStreamDefinitionExistException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftSessionExpiredException;
import org.wso2.carbon.agent.commons.thrift.exception.ThriftUndefinedEventTypeException;
import org.wso2.carbon.agent.commons.thrift.service.secure.ThriftSecureEventTransmissionService;
import org.wso2.carbon.agent.server.internal.EventDispatcher;
import org.wso2.carbon.agent.server.internal.service.secure.SecureEventReceiverService;

public class ThriftSecureEventTransmissionServiceImpl
implements ThriftSecureEventTransmissionService.Iface {
    private SecureEventReceiverService secureEventReceiverService;

    public ThriftSecureEventTransmissionServiceImpl(EventDispatcher eventDispatcher) {
        this.secureEventReceiverService = new SecureEventReceiverService(eventDispatcher);
    }

    public String connect(String username, String password) throws ThriftAuthenticationException {
        try {
            return SecureEventReceiverService.connect(username, password);
        }
        catch (AuthenticationException e) {
            throw new ThriftAuthenticationException(e.getErrorMessage());
        }
    }

    public void disconnect(String sessionId) throws TException {
        try {
            SecureEventReceiverService.disconnect(sessionId);
        }
        catch (Exception e) {
            throw new TException(e.getMessage());
        }
    }

    public String defineEventStream(String sessionId, String streamDefinition) throws TException, ThriftSessionExpiredException, ThriftDifferentStreamDefinitionAlreadyDefinedException, ThriftMalformedStreamDefinitionException {
        try {
            return this.secureEventReceiverService.defineEventStream(sessionId, streamDefinition);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new ThriftDifferentStreamDefinitionAlreadyDefinedException(e.getErrorMessage());
        }
        catch (MalformedStreamDefinitionException e) {
            throw new ThriftMalformedStreamDefinitionException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }

    public String findEventStreamId(String sessionId, String streamName, String streamVersion) throws ThriftNoStreamDefinitionExistException, ThriftSessionExpiredException, TException {
        try {
            return this.secureEventReceiverService.findEventStreamId(sessionId, streamName, streamVersion);
        }
        catch (NoStreamDefinitionExistException e) {
            throw new ThriftNoStreamDefinitionExistException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }

    public void publish(ThriftEventBundle eventBundle) throws ThriftUndefinedEventTypeException, ThriftSessionExpiredException, TException {
        try {
            this.secureEventReceiverService.publish(eventBundle, eventBundle.getSessionId());
        }
        catch (UndefinedEventTypeException e) {
            throw new ThriftUndefinedEventTypeException(e.getErrorMessage());
        }
        catch (SessionTimeoutException e) {
            throw new ThriftSessionExpiredException(e.getErrorMessage());
        }
    }
}

