/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.service.secure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.commons.exception.AuthenticationException;
import org.wso2.carbon.agent.server.internal.EventDispatcher;
import org.wso2.carbon.agent.server.internal.authentication.Authenticator;
import org.wso2.carbon.agent.server.internal.service.general.EventReceiverService;

public class SecureEventReceiverService
extends EventReceiverService {
    private static final Log log = LogFactory.getLog(Authenticator.class);

    public SecureEventReceiverService(EventDispatcher eventDispatcher) {
        super(eventDispatcher);
    }

    public static String connect(String username, String password) throws AuthenticationException {
        log.info((Object)(username + " connected"));
        try {
            return Authenticator.getInstance().authenticate(username, password);
        }
        catch (AuthenticationException e) {
            throw new AuthenticationException(username + " is not authorised to access the server " + e.getErrorMessage());
        }
    }

    public static void disconnect(String sessionId) throws Exception {
        log.info((Object)(sessionId + " disconnected"));
        Authenticator.getInstance().logout(sessionId);
    }
}

