/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.queue;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.server.AgentCallback;
import org.wso2.carbon.agent.server.internal.queue.QueueWorker;
import org.wso2.carbon.agent.server.internal.utils.EventComposite;

public class EventQueue {
    private static final Log log = LogFactory.getLog(EventQueue.class);
    private BlockingQueue<EventComposite> eventQueue;
    private ExecutorService executorService;
    private List<AgentCallback> subscribers;

    public EventQueue(List<AgentCallback> subscribers) {
        this.subscribers = subscribers;
        this.executorService = Executors.newFixedThreadPool(10);
        this.eventQueue = new ArrayBlockingQueue<EventComposite>(10000);
    }

    public void publish(EventComposite eventComposite) {
        try {
            this.eventQueue.put(eventComposite);
        }
        catch (InterruptedException e) {
            String logMessage = "Failure to insert event into queue";
            log.warn((Object)logMessage);
        }
        this.executorService.submit(new QueueWorker(this.eventQueue, this.subscribers));
    }

    protected void finalize() throws Throwable {
        this.executorService.shutdown();
        super.finalize();
    }
}

