/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal.authentication;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.commons.exception.AuthenticationException;
import org.wso2.carbon.agent.server.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.agent.server.internal.authentication.session.AgentSession;
import org.wso2.carbon.agent.server.internal.authentication.session.SessionCache;

public final class Authenticator {
    private static final Log log = LogFactory.getLog(Authenticator.class);
    private static Authenticator instance = new Authenticator();
    private static SessionCache sessionCache = new SessionCache(30);
    private AuthenticationHandler authenticationHandler;

    private Authenticator() {
    }

    public static Authenticator getInstance() {
        return instance;
    }

    public void init(AuthenticationHandler authenticationHandler) {
        this.authenticationHandler = authenticationHandler;
    }

    public String authenticate(String userName, String password) throws AuthenticationException {
        boolean isSuccessful;
        if (userName == null) {
            this.logAndAuthenticationException("Authentication request was missing the user name ");
        }
        if (password == null) {
            this.logAndAuthenticationException("Authentication request was missing the required password");
        }
        if (isSuccessful = this.authenticationHandler.authenticate(userName, password)) {
            String sessionId = UUID.randomUUID().toString();
            AgentSession agentSession = sessionCache.getSession(sessionId);
            agentSession.setUsername(userName);
            agentSession.setPassword(password);
            agentSession.setCreatedAt(System.currentTimeMillis());
            return sessionId;
        }
        this.logAndAuthenticationException("wrong userName or password");
        return null;
    }

    private void logAndAuthenticationException(String msg) throws AuthenticationException {
        log.error((Object)msg);
        throw new AuthenticationException(msg);
    }

    public void logout(String sessionId) {
        sessionCache.removeSession(sessionId);
    }

    public AgentSession getSession(String sessionId) {
        return sessionCache.getSession(sessionId);
    }
}

