/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.server.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.agent.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.agent.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.agent.server.AgentServer;
import org.wso2.carbon.agent.server.AgentServerFactory;
import org.wso2.carbon.agent.server.conf.AgentServerConfiguration;
import org.wso2.carbon.agent.server.datastore.InMemoryStreamDefinitionStore;
import org.wso2.carbon.agent.server.datastore.StreamDefinitionStore;
import org.wso2.carbon.agent.server.exception.AgentServerConfigurationException;
import org.wso2.carbon.agent.server.exception.AgentServerException;
import org.wso2.carbon.agent.server.internal.AbstractAgentServer;
import org.wso2.carbon.agent.server.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.agent.server.internal.authentication.CarbonAuthenticationHandler;
import org.wso2.carbon.agent.server.internal.utils.AgentServerBuilder;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class AgentServerServiceDS {
    private static final Log log = LogFactory.getLog(AgentServerServiceDS.class);
    private AuthenticationService authenticationService;
    private AbstractAgentServer agentServer;
    private ServiceRegistration agentServerService;
    private ServerConfigurationService serverConfiguration;
    private ConfigurationContextService configurationContext;

    protected void activate(ComponentContext context) {
        block13: {
            try {
                AgentServerConfiguration agentServerConfiguration = new AgentServerConfiguration(7711, 7611);
                ArrayList<String[]> eventStreamDefinitions = new ArrayList<String[]>();
                AgentServerBuilder.populateConfigurations(this.serverConfiguration, agentServerConfiguration, eventStreamDefinitions);
                if (this.agentServer != null) break block13;
                String definitionStoreName = agentServerConfiguration.getStreamDefinitionStoreName();
                StreamDefinitionStore streamDefinitionStore = null;
                try {
                    streamDefinitionStore = (StreamDefinitionStore)Class.forName(definitionStoreName).newInstance();
                }
                catch (Exception e) {
                    log.warn((Object)("The stream definition store :" + definitionStoreName + " is cannot be created hence using org.wso2.carbon.agent.server.datastore.InMemoryStreamDefinitionStore"), (Throwable)e);
                    streamDefinitionStore = new InMemoryStreamDefinitionStore();
                }
                this.agentServer = new AgentServerFactory().createAgentServer(agentServerConfiguration, (AuthenticationHandler)new CarbonAuthenticationHandler(this.authenticationService), streamDefinitionStore);
                String serverUrl = CarbonUtils.getServerURL((ServerConfigurationService)this.serverConfiguration, (ConfigurationContext)this.configurationContext.getServerConfigContext());
                String hostName = null;
                try {
                    hostName = new URL(serverUrl).getHost();
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("The server url :" + serverUrl + " is malformed URL hence hostname is assigned as 'localhost'"));
                    hostName = "localhost";
                }
                this.agentServer.start(hostName);
                for (String[] streamDefinition : eventStreamDefinitions) {
                    try {
                        this.agentServer.saveEventStreamDefinition(streamDefinition[0], streamDefinition[1]);
                    }
                    catch (MalformedStreamDefinitionException e) {
                        log.error((Object)("Malformed Stream Definition for " + streamDefinition[0] + ": " + streamDefinition[1]), (Throwable)e);
                    }
                    catch (DifferentStreamDefinitionAlreadyDefinedException e) {
                        log.warn((Object)("Redefining event stream of " + streamDefinition[0] + ": " + streamDefinition[1]), (Throwable)e);
                    }
                    catch (RuntimeException e) {
                        log.error((Object)("Error in defining event stream " + streamDefinition[0] + ": " + streamDefinition[1]), (Throwable)e);
                    }
                }
                this.agentServerService = context.getBundleContext().registerService(AgentServer.class.getName(), (Object)this.agentServer, null);
                log.info((Object)"Successfully deployed Agent Server ");
            }
            catch (AgentServerConfigurationException e) {
                log.error((Object)"Agent Server Configuration is not correct hence can not create and start Agent Server ", (Throwable)e);
            }
            catch (AgentServerException e) {
                log.error((Object)"Can not create and start Agent Server ", (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error((Object)"Error in starting Agent Server ", (Throwable)e);
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        context.getBundleContext().ungetService(this.agentServerService.getReference());
        this.agentServer.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent server");
        }
    }

    protected void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void unsetAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = null;
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        this.serverConfiguration = null;
    }

    protected void setConfigurationContext(ConfigurationContextService configurationContext) {
        this.configurationContext = configurationContext;
    }

    protected void unsetConfigurationContext(ConfigurationContextService configurationContext) {
        this.configurationContext = null;
    }
}

