/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.internal.utils;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.agent.commons.Event;
import org.wso2.carbon.agent.commons.thrift.data.ThriftEventBundle;

public final class ThriftEventConverter {
    private static Log log = LogFactory.getLog(ThriftEventConverter.class);

    private ThriftEventConverter() {
    }

    public static ThriftEventBundle toThriftEventBundle(Event event, ThriftEventBundle eventBundle, String sessionId) {
        ThriftEventBundle thriftEventBundle = eventBundle;
        if (thriftEventBundle == null) {
            thriftEventBundle = new ThriftEventBundle();
            thriftEventBundle.setStringAttributeList(new LinkedList<String>());
            thriftEventBundle.setLongAttributeList(new LinkedList<Long>());
            thriftEventBundle.setSessionId(sessionId);
            thriftEventBundle.setEventNum(0);
        }
        thriftEventBundle.setEventNum(thriftEventBundle.getEventNum() + 1);
        thriftEventBundle.addToStringAttributeList(event.getStreamId());
        thriftEventBundle.addToLongAttributeList(event.getTimeStamp());
        thriftEventBundle = ThriftEventConverter.assignAttributes(thriftEventBundle, event.getMetaData());
        thriftEventBundle = ThriftEventConverter.assignAttributes(thriftEventBundle, event.getCorrelationData());
        thriftEventBundle = ThriftEventConverter.assignAttributes(thriftEventBundle, event.getPayloadData());
        return thriftEventBundle;
    }

    private static ThriftEventBundle assignAttributes(ThriftEventBundle thriftEventBundle, Object[] attributes) {
        if (attributes != null) {
            for (Object object : attributes) {
                if (object instanceof Integer) {
                    if (!thriftEventBundle.isSetIntAttributeList()) {
                        thriftEventBundle.setIntAttributeList(new LinkedList<Integer>());
                    }
                    thriftEventBundle.addToIntAttributeList((Integer)object);
                    continue;
                }
                if (object instanceof Float) {
                    if (!thriftEventBundle.isSetDoubleAttributeList()) {
                        thriftEventBundle.setDoubleAttributeList(new LinkedList<Double>());
                    }
                    thriftEventBundle.addToDoubleAttributeList(((Float)object).doubleValue());
                    continue;
                }
                if (object instanceof Long) {
                    if (!thriftEventBundle.isSetLongAttributeList()) {
                        thriftEventBundle.setLongAttributeList(new LinkedList<Long>());
                    }
                    thriftEventBundle.addToLongAttributeList((Long)object);
                    continue;
                }
                if (object instanceof String) {
                    if (!thriftEventBundle.isSetStringAttributeList()) {
                        thriftEventBundle.setStringAttributeList(new LinkedList<String>());
                    }
                    thriftEventBundle.addToStringAttributeList((String)object);
                    continue;
                }
                if (object instanceof Boolean) {
                    if (!thriftEventBundle.isSetBoolAttributeList()) {
                        thriftEventBundle.setBoolAttributeList(new LinkedList<Boolean>());
                    }
                    thriftEventBundle.addToBoolAttributeList((Boolean)object);
                    continue;
                }
                if (object instanceof Double) {
                    if (!thriftEventBundle.isSetDoubleAttributeList()) {
                        thriftEventBundle.setDoubleAttributeList(new LinkedList<Double>());
                    }
                    thriftEventBundle.addToDoubleAttributeList((Double)object);
                    continue;
                }
                if (object == null) {
                    if (!thriftEventBundle.isSetStringAttributeList()) {
                        thriftEventBundle.setStringAttributeList(new LinkedList<String>());
                    }
                    thriftEventBundle.addToStringAttributeList("_null");
                    continue;
                }
                log.error((Object)("Undefined attribute type : " + object));
            }
        }
        return thriftEventBundle;
    }
}

