/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.internal.publisher.authenticator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.wso2.carbon.agent.commons.exception.AuthenticationException;
import org.wso2.carbon.agent.conf.DataPublisherConfiguration;
import org.wso2.carbon.agent.exception.AgentAuthenticatorException;
import org.wso2.carbon.agent.exception.AgentException;
import org.wso2.carbon.agent.exception.TransportException;

public abstract class AgentAuthenticator {
    private GenericKeyedObjectPool secureTransportPool;
    private static Log log = LogFactory.getLog(AgentAuthenticator.class);

    public AgentAuthenticator(GenericKeyedObjectPool secureTransportPool) {
        this.secureTransportPool = secureTransportPool;
    }

    public String connect(DataPublisherConfiguration dataPublisherConfiguration) throws AuthenticationException, TransportException, AgentException {
        Object client = null;
        try {
            client = this.secureTransportPool.borrowObject((Object)dataPublisherConfiguration.getPublisherKey());
            String string = this.connect(client, dataPublisherConfiguration.getReceiverConfiguration().getUserName(), dataPublisherConfiguration.getReceiverConfiguration().getPassword());
            return string;
        }
        catch (AgentAuthenticatorException e) {
            throw new AuthenticationException("Access denied for user " + dataPublisherConfiguration.getReceiverConfiguration().getUserName() + " to login " + dataPublisherConfiguration.getPublisherKey(), e);
        }
        catch (Exception e) {
            throw new AgentException("Cannot borrow client for " + dataPublisherConfiguration.getPublisherKey(), e);
        }
        finally {
            try {
                this.secureTransportPool.returnObject((Object)dataPublisherConfiguration.getPublisherKey(), client);
            }
            catch (Exception e) {
                this.secureTransportPool.clear((Object)dataPublisherConfiguration.getPublisherKey());
            }
        }
    }

    protected abstract String connect(Object var1, String var2, String var3) throws AuthenticationException, AgentAuthenticatorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(DataPublisherConfiguration dataPublisherConfiguration) {
        Object client = null;
        try {
            client = this.secureTransportPool.borrowObject((Object)dataPublisherConfiguration.getPublisherKey());
            this.disconnect(client, dataPublisherConfiguration.getSessionId());
        }
        catch (Exception e) {
            log.error((Object)("Cannot connect to the server at " + dataPublisherConfiguration.getPublisherKey() + "Authenticator"), (Throwable)e);
        }
        finally {
            try {
                this.secureTransportPool.returnObject((Object)dataPublisherConfiguration.getPublisherKey(), client);
            }
            catch (Exception e) {
                this.secureTransportPool.clear((Object)dataPublisherConfiguration.getPublisherKey());
            }
        }
    }

    public GenericKeyedObjectPool getSecureTransportPool() {
        return this.secureTransportPool;
    }

    protected abstract void disconnect(Object var1, String var2) throws AgentAuthenticatorException;
}

