/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.agent.Agent;
import org.wso2.carbon.agent.exception.AgentConfigurationException;
import org.wso2.carbon.agent.internal.utils.AgentBuilder;

public class AgentServiceDS {
    private static Log log = LogFactory.getLog(AgentServiceDS.class);
    private Agent agent;
    private ServiceRegistration agentServerService;

    protected void activate(ComponentContext context) {
        try {
            this.agentServerService = context.getBundleContext().registerService(Agent.class.getName(), (Object)new Agent(AgentBuilder.loadAgentConfiguration()), null);
            log.info((Object)"Successfully deployed Agent Client");
        }
        catch (AgentConfigurationException e) {
            log.error((Object)"Can not create and start Agent ", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        context.getBundleContext().ungetService(this.agentServerService.getReference());
        this.agent.shutdown();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent");
        }
    }
}

