/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authentication.internal;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.identity.authentication.AuthenticationServiceImpl;
import org.wso2.carbon.identity.authentication.SharedKeyAccessService;
import org.wso2.carbon.identity.authentication.SharedKeyAccessServiceImpl;
import org.wso2.carbon.user.api.UserRealmService;
import org.wso2.carbon.user.core.service.RealmService;

public class AuthenticationServiceComponent {
    private static Log log = LogFactory.getLog(AuthenticationServiceComponent.class);
    private ServiceRegistration authenticationService;
    private ServiceRegistration sharedKeyAccessService;
    private RealmService realmService = null;

    protected void activate(ComponentContext componentContext) {
        String accessKey = UUID.randomUUID().toString();
        SharedKeyAccessServiceImpl keyAccessService = new SharedKeyAccessServiceImpl(accessKey);
        this.sharedKeyAccessService = componentContext.getBundleContext().registerService(SharedKeyAccessService.class.getName(), (Object)keyAccessService, null);
        this.authenticationService = componentContext.getBundleContext().registerService(AuthenticationService.class.getName(), (Object)new AuthenticationServiceImpl(keyAccessService, (UserRealmService)this.realmService), null);
    }

    protected void deactivate(ComponentContext componentContext) {
        componentContext.getBundleContext().ungetService(this.authenticationService.getReference());
        componentContext.getBundleContext().ungetService(this.sharedKeyAccessService.getReference());
    }

    protected void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        this.realmService = null;
    }
}

