/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.agent.commons.utils;

import com.google.gson.Gson;
import java.util.List;
import org.wso2.carbon.agent.commons.Attribute;
import org.wso2.carbon.agent.commons.AttributeType;
import org.wso2.carbon.agent.commons.EventStreamDefinition;
import org.wso2.carbon.agent.commons.exception.MalformedStreamDefinitionException;

public final class EventConverter {
    public static final String nullString = "_null";
    private static Gson gson = new Gson();

    private EventConverter() {
    }

    public static AttributeType[] generateAttributeTypeArray(List<Attribute> attributes) {
        if (attributes != null) {
            AttributeType[] attributeTypes = new AttributeType[attributes.size()];
            int metaDataSize = attributes.size();
            for (int i = 0; i < metaDataSize; ++i) {
                Attribute attribute = attributes.get(i);
                attributeTypes[i] = attribute.getType();
            }
            return attributeTypes;
        }
        return null;
    }

    public static EventStreamDefinition convertFromJson(String streamDefinition) throws MalformedStreamDefinitionException {
        try {
            EventStreamDefinition tempEventStreamDefinition = (EventStreamDefinition)gson.fromJson(streamDefinition.replaceAll("(?i)int", "INT").replaceAll("(?i)long", "LONG").replaceAll("(?i)float", "FLOAT").replaceAll("(?i)double", "DOUBLE").replaceAll("(?i)bool", "BOOL").replaceAll("(?i)string", "STRING"), EventStreamDefinition.class);
            String name = tempEventStreamDefinition.getName();
            String version = tempEventStreamDefinition.getVersion();
            if (version == null) {
                version = "1.0.0";
            }
            if (name == null) {
                throw new MalformedStreamDefinitionException("stream name is null");
            }
            EventStreamDefinition eventStreamDefinition = new EventStreamDefinition(name, version);
            eventStreamDefinition.setMetaData(tempEventStreamDefinition.getMetaData());
            eventStreamDefinition.setCorrelationData(tempEventStreamDefinition.getCorrelationData());
            eventStreamDefinition.setPayloadData(tempEventStreamDefinition.getPayloadData());
            eventStreamDefinition.setNickName(tempEventStreamDefinition.getNickName());
            eventStreamDefinition.setDescription(tempEventStreamDefinition.getDescription());
            eventStreamDefinition.setDescription(tempEventStreamDefinition.getDescription());
            eventStreamDefinition.setTags(tempEventStreamDefinition.getTags());
            return eventStreamDefinition;
        }
        catch (RuntimeException e) {
            throw new MalformedStreamDefinitionException(" Malformed stream definition " + streamDefinition, e);
        }
    }

    public static String convertToJson(EventStreamDefinition existingDefinition) {
        return gson.toJson((Object)existingDefinition);
    }
}

