/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.admin.mgt.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.admin.mgt.beans.AdminMgtInfoBean;
import org.wso2.carbon.admin.mgt.exception.AdminManagementException;
import org.wso2.carbon.admin.mgt.internal.util.PasswordUtil;
import org.wso2.carbon.admin.mgt.util.AdminMgtUtil;
import org.wso2.carbon.captcha.mgt.beans.CaptchaInfoBean;
import org.wso2.carbon.captcha.mgt.util.CaptchaUtil;

public class AdminManagementService {
    private static final Log log = LogFactory.getLog(AdminManagementService.class);

    public boolean initiatePasswordReset(AdminMgtInfoBean adminInfoBean, CaptchaInfoBean captchaInfoBean) throws AdminManagementException {
        try {
            CaptchaUtil.processCaptchaInfoBean((CaptchaInfoBean)captchaInfoBean);
        }
        catch (Exception e) {
            String msg = "Captcha validation failed. Failure in verifying the provided captcha for initiate password reset. ";
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, e);
        }
        String tenantDomain = adminInfoBean.getTenantDomain();
        if (!tenantDomain.trim().equals("")) {
            try {
                AdminMgtUtil.checkIsDomainValid(adminInfoBean.getTenantDomain());
            }
            catch (Exception e) {
                String msg = "Attempt to check the validity of the given domain for the password reset, failed.";
                log.error((Object)msg, (Throwable)e);
                return false;
            }
        }
        return PasswordUtil.initiatePasswordReset(adminInfoBean);
    }

    public boolean updatePasswordWithUserInput(AdminMgtInfoBean adminInfoBean, CaptchaInfoBean captchaInfoBean, String confirmationKey) throws AdminManagementException {
        String domain = adminInfoBean.getTenantDomain();
        String tenantLessUserName = adminInfoBean.getTenantLessUserName();
        String userName = AdminMgtUtil.getUserNameWithDomain(tenantLessUserName, domain);
        boolean isValidRequest = PasswordUtil.proceedUpdateCredentials(domain, tenantLessUserName, confirmationKey);
        boolean isPasswordUpdated = false;
        if (isValidRequest) {
            try {
                CaptchaUtil.processCaptchaInfoBean((CaptchaInfoBean)captchaInfoBean);
            }
            catch (Exception e) {
                String msg = "Captcha validation failed. Failure in verifying the provided captcha for updating the password";
                log.error((Object)msg, (Throwable)e);
                throw new AdminManagementException(msg, e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling the password update method for the user: " + userName));
            }
            isPasswordUpdated = PasswordUtil.updateCredentials(adminInfoBean);
        }
        log.info((Object)("Password reset status of user " + userName + " is: " + isPasswordUpdated));
        AdminMgtUtil.cleanupResources(tenantLessUserName, domain);
        return isPasswordUpdated;
    }

    public CaptchaInfoBean generateRandomCaptcha() throws Exception {
        CaptchaUtil.cleanOldCaptchas();
        return CaptchaUtil.generateCaptchaImage();
    }
}

