/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.admin.mgt.internal.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.admin.mgt.exception.AdminManagementException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class ClaimsMgtUtil {
    private static final Log log = LogFactory.getLog(ClaimsMgtUtil.class);

    public static String getTenantAdminClaim(RealmService realmService, int tenantId, String claim) throws AdminManagementException {
        String userName;
        try {
            userName = ClaimsMgtUtil.getAdminUserNameFromTenantId(realmService, tenantId);
        }
        catch (AdminManagementException e) {
            String msg = "Couldn't find the admin user name for the tenant with tenant id: " + tenantId;
            log.warn((Object)msg);
            throw new AdminManagementException(msg, e);
        }
        return ClaimsMgtUtil.getClaimFromUserStoreManager(realmService, userName, tenantId, claim);
    }

    public static String getClaimFromUserStoreManager(RealmService realmService, String userName, int tenantId, String claim) throws AdminManagementException {
        UserStoreManager userStoreManager = null;
        String claimValue = "";
        try {
            if (realmService.getTenantUserRealm(tenantId) != null) {
                userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            }
        }
        catch (UserStoreException e) {
            String msg = "Error retrieving the user store manager for the tenant";
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
        try {
            if (userStoreManager != null) {
                claimValue = userStoreManager.getUserClaimValue(userName, claim, "default");
            }
            return claimValue;
        }
        catch (UserStoreException e) {
            String msg = "Unable to retrieve the claim for the given tenant";
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
    }

    public static String getFirstName(RealmService realmService, int tenantId) throws AdminManagementException {
        String firstName;
        try {
            firstName = ClaimsMgtUtil.getTenantAdminClaim(realmService, tenantId, "http://wso2.org/claims/givenname");
        }
        catch (Exception e) {
            String msg = "Unable to get the first name from the user store manager";
            log.warn((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, e);
        }
        return firstName;
    }

    public static String getEmailAddressFromUserProfile(RealmService realmService, String userName, int tenantId) throws AdminManagementException {
        return ClaimsMgtUtil.getClaimFromUserStoreManager(realmService, userName, tenantId, "http://wso2.org/claims/emailaddress");
    }

    public static String getAdminUserNameFromTenantId(RealmService realmService, int tenantId) throws AdminManagementException {
        String tenantAdminName = "";
        if (tenantId == -1234) {
            return realmService.getBootstrapRealmConfiguration().getAdminUserName();
        }
        try {
            if (realmService.getTenantManager().getTenant(tenantId) != null) {
                tenantAdminName = realmService.getTenantManager().getTenant(tenantId).getAdminName();
            }
        }
        catch (UserStoreException e) {
            String msg = "Unable to retrieve the admin name for the tenant with the tenant Id: " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
        return tenantAdminName;
    }
}

