/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.admin.mgt.ui.utils;

import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.admin.mgt.stub.AdminManagementServiceAdminManagementExceptionException;
import org.wso2.carbon.admin.mgt.stub.beans.xsd.AdminMgtInfoBean;
import org.wso2.carbon.admin.mgt.stub.beans.xsd.CaptchaInfoBean;
import org.wso2.carbon.admin.mgt.ui.clients.AdminManagementClient;
import org.wso2.carbon.registry.common.ui.UIException;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class PasswordConfigUtil {
    private static final Log log = LogFactory.getLog(PasswordConfigUtil.class);

    public static boolean initiatePasswordReset(HttpServletRequest request, ServletConfig config, HttpSession session) throws UIException {
        String tenantLessUserName = "";
        String domain = "";
        try {
            tenantLessUserName = request.getParameter("admin");
            domain = PasswordConfigUtil.resolveDomainName(request.getParameter("domain"));
            if (tenantLessUserName.trim().equals("")) {
                String msg = "Provided user name is empty";
                log.error((Object)msg);
                return false;
            }
            AdminMgtInfoBean adminInfoBean = new AdminMgtInfoBean();
            adminInfoBean.setTenantLessUserName(tenantLessUserName);
            adminInfoBean.setTenantDomain(domain);
            CaptchaInfoBean captchaInfoBean = new CaptchaInfoBean();
            captchaInfoBean.setSecretKey(request.getParameter("captcha-secret-key"));
            captchaInfoBean.setUserAnswer(request.getParameter("captcha-user-answer"));
            AdminManagementClient adminManagementClient = new AdminManagementClient(config, session);
            return adminManagementClient.initiatePasswordReset(adminInfoBean, captchaInfoBean);
        }
        catch (Exception e) {
            AxisFault fault = new AxisFault(e.getMessage());
            String msg = fault.getReason() + " Failed to reset password. tenant-domain: " + domain + " user: " + tenantLessUserName;
            log.error((Object)msg, (Throwable)e);
            throw new UIException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean updatePasswordWithUserInput(HttpServletRequest request, ServletConfig config, HttpSession session) throws UIException {
        String domain = request.getParameter("domain");
        String tenantLessUserName = request.getParameter("admin");
        String password = request.getParameter("admin-password");
        String confirmationKey = request.getParameter("confirmationKey");
        AdminMgtInfoBean adminInfoBean = new AdminMgtInfoBean();
        adminInfoBean.setTenantDomain(domain);
        adminInfoBean.setTenantLessUserName(tenantLessUserName);
        adminInfoBean.setPassword(password);
        CaptchaInfoBean captchaInfoBean = new CaptchaInfoBean();
        try {
            captchaInfoBean.setSecretKey(request.getParameter("captcha-secret-key"));
            captchaInfoBean.setUserAnswer(request.getParameter("captcha-user-answer"));
            AdminManagementClient adminManagementClient = new AdminManagementClient(config, session);
            return adminManagementClient.updatePasswordWithUserInput(adminInfoBean, captchaInfoBean, confirmationKey);
        }
        catch (AdminManagementServiceAdminManagementExceptionException e) {
            String errorMsg = e.getFaultMessage().getAdminManagementException().getErrorMsg();
            AxisFault fault = new AxisFault(e.getMessage());
            String msg = errorMsg + " " + fault.getReason() + " Failed to update password. tenant-domain: " + domain;
            log.error((Object)errorMsg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            AxisFault fault = new AxisFault(e.getMessage());
            String msg = fault.getReason() + " Failed to update password. tenant-domain: " + domain;
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
        catch (RemoteException e) {
            AxisFault fault = new AxisFault(e.getMessage());
            String msg = fault.getReason() + " Failed to update password. tenant-domain: " + domain;
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }

    public static String resolveDomainName(String domainNameUserInput) {
        if (domainNameUserInput == null) {
            String msg = "Provided domain name is null";
            log.error((Object)msg);
            return "";
        }
        String domainName = domainNameUserInput.trim();
        if (domainName.startsWith("www.")) {
            domainName = domainName.substring(4);
        }
        return domainName;
    }

    public static HttpServletRequest readIntermediateData(HttpServletRequest request, String data) {
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(data));
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator it = documentElement.getChildElements();
            while (it.hasNext()) {
                OMElement element = (OMElement)it.next();
                if ("admin".equals(element.getLocalName())) {
                    request.setAttribute("admin", (Object)element.getText());
                    continue;
                }
                if ("firstname".equals(element.getText())) {
                    request.setAttribute("firstname", (Object)element.getText());
                    continue;
                }
                if ("lastname".equals(element.getText())) {
                    request.setAttribute("lastname", (Object)element.getText());
                    continue;
                }
                if ("email".equals(element.getLocalName())) {
                    request.setAttribute("email", (Object)element.getText());
                    continue;
                }
                if ("tenantDomain".equals(element.getLocalName())) {
                    request.setAttribute("tenantDomain", (Object)element.getText());
                    continue;
                }
                if (!"confirmationKey".equals(element.getLocalName())) continue;
                request.setAttribute("confirmationKey", (Object)element.getText());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error parsing xml", (Throwable)e);
        }
        return request;
    }

    public static CaptchaInfoBean generateRandomCaptcha(ServletConfig config, HttpSession session) throws UIException {
        try {
            AdminManagementClient selfRegistrationClient = new AdminManagementClient(config, session);
            return selfRegistrationClient.generateRandomCaptcha();
        }
        catch (Exception e) {
            String msg = "Error in generating the captcha image.";
            log.error((Object)msg, (Throwable)e);
            throw new UIException(msg, (Throwable)e);
        }
    }
}

