/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.admin.mgt.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.admin.mgt.exception.AdminManagementException;
import org.wso2.carbon.admin.mgt.internal.AdminManagementServiceComponent;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class AdminMgtUtil {
    private static final Log log = LogFactory.getLog(AdminMgtUtil.class);

    public static void checkIsDomainValid(String domainName) throws AdminManagementException {
        if (domainName == null || domainName.equals("")) {
            String msg = "Provided domain name is empty.";
            log.error((Object)msg);
            throw new AdminManagementException(msg);
        }
        int indexOfDot = domainName.indexOf(".");
        if (indexOfDot == 0) {
            String msg = "Invalid domain, starting with '.'";
            log.error((Object)msg);
            throw new AdminManagementException(msg);
        }
        if (domainName.matches(".*[^a-zA-Z0-9\\._\\-].*")) {
            String msg = "The tenant domain ' " + domainName + " ' contains one or more illegal characters. the valid characters are " + "letters, numbers, '.', '-' and '_'";
            log.error((Object)msg);
            throw new AdminManagementException(msg);
        }
    }

    public static int getTenantIdFromDomain(String domain) throws AdminManagementException {
        int tenantId;
        TenantManager tenantManager = AdminManagementServiceComponent.getTenantManager();
        if (domain.trim().equals("")) {
            tenantId = -1234;
            if (log.isDebugEnabled()) {
                String msg = "Password reset attempt on Super Tenant";
                log.debug((Object)msg);
            }
        } else {
            try {
                tenantId = tenantManager.getTenantId(domain);
                if (tenantId < 1) {
                    String msg = "Only the existing tenants can update the password";
                    log.error((Object)msg);
                    throw new AdminManagementException(msg);
                }
            }
            catch (UserStoreException e) {
                String msg = "Error in retrieving tenant id of tenant domain: " + domain + ".";
                log.error((Object)msg);
                throw new AdminManagementException(msg, (Exception)((Object)e));
            }
        }
        return tenantId;
    }

    public static String getAdminManagementPath(String tenantLessUserName, String domain) throws AdminManagementException {
        int tenantId;
        try {
            tenantId = AdminMgtUtil.getTenantIdFromDomain(domain);
        }
        catch (AdminManagementException e) {
            String msg = "Error in getting tenant, tenant domain: " + domain + ".";
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, e);
        }
        String adminManagementPath = tenantId == -1234 ? "/repository/components/org.wso2.carbon.admin-management-flag/" + tenantLessUserName : "/repository/components/org.wso2.carbon.admin-management-flag/" + domain + "/" + tenantLessUserName;
        return adminManagementPath;
    }

    public static void cleanupResources(String tenantLessUserName, String domain) throws AdminManagementException {
        String adminManagementPath = AdminMgtUtil.getAdminManagementPath(tenantLessUserName, domain);
        try {
            Resource resource;
            Resource tempResource;
            UserRegistry superTenantSystemRegistry = AdminManagementServiceComponent.getGovernanceSystemRegistry(-1234);
            if (superTenantSystemRegistry.resourceExists(adminManagementPath) && (tempResource = superTenantSystemRegistry.get((resource = superTenantSystemRegistry.get(adminManagementPath)).getPath())) != null) {
                superTenantSystemRegistry.delete(resource.getPath());
            }
        }
        catch (RegistryException e) {
            String msg = "Registry resource doesn't exist at the path, " + adminManagementPath;
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
    }

    public static String getUserNameWithDomain(String tenantLessUserName, String domain) {
        String userName = tenantLessUserName;
        if (!domain.trim().equals("")) {
            userName = tenantLessUserName + "@" + domain;
        }
        return userName;
    }
}

