/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.admin.mgt.ui.clients;

import java.rmi.RemoteException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.admin.mgt.stub.AdminManagementServiceAdminManagementExceptionException;
import org.wso2.carbon.admin.mgt.stub.AdminManagementServiceStub;
import org.wso2.carbon.admin.mgt.stub.beans.xsd.AdminMgtInfoBean;
import org.wso2.carbon.admin.mgt.stub.beans.xsd.CaptchaInfoBean;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class AdminManagementClient {
    private static final Log log = LogFactory.getLog(AdminManagementClient.class);
    private AdminManagementServiceStub stub;
    private String epr;

    public AdminManagementClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "AdminManagementService";
        try {
            this.stub = new AdminManagementServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AddServices service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public AdminManagementClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "AdminManagementService";
        try {
            this.stub = new AdminManagementServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public boolean updatePasswordWithUserInput(AdminMgtInfoBean adminInfoBean, CaptchaInfoBean captchaInfoBean, String confirmationKey) throws AdminManagementServiceAdminManagementExceptionException, RemoteException {
        return this.stub.updatePasswordWithUserInput(adminInfoBean, captchaInfoBean, confirmationKey);
    }

    public boolean initiatePasswordReset(AdminMgtInfoBean adminInfoBean, CaptchaInfoBean captchaInfoBean) throws Exception {
        return this.stub.initiatePasswordReset(adminInfoBean, captchaInfoBean);
    }

    public CaptchaInfoBean generateRandomCaptcha() throws Exception {
        return this.stub.generateRandomCaptcha();
    }
}

