/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.admin.mgt.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.admin.mgt.beans.AdminMgtInfoBean;
import org.wso2.carbon.admin.mgt.exception.AdminManagementException;
import org.wso2.carbon.admin.mgt.internal.AdminManagementServiceComponent;
import org.wso2.carbon.admin.mgt.internal.util.ClaimsMgtUtil;
import org.wso2.carbon.admin.mgt.util.AdminMgtUtil;
import org.wso2.carbon.email.verification.util.EmailVerifcationSubscriber;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class PasswordUtil {
    private static final Log log = LogFactory.getLog(PasswordUtil.class);
    private static Log audit = CarbonConstants.AUDIT_LOG;

    public static boolean initiatePasswordReset(AdminMgtInfoBean adminInfoBean) throws AdminManagementException {
        String email;
        String tenantLessUserName = adminInfoBean.getTenantLessUserName();
        String domainName = adminInfoBean.getTenantDomain();
        TenantManager tenantManager = AdminManagementServiceComponent.getTenantManager();
        int tenantId = AdminMgtUtil.getTenantIdFromDomain(domainName);
        String userName = tenantId == -1234 ? tenantLessUserName : tenantLessUserName + "@" + domainName;
        Tenant tenant = null;
        try {
            tenant = (Tenant)tenantManager.getTenant(tenantId);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String msg = "Unable to get the tenant with the tenantId: " + tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
        try {
            email = PasswordUtil.getEmailAddressForUser(tenantLessUserName, userName, tenantId, tenant);
        }
        catch (AdminManagementException e) {
            log.error((Object)"No email address associated with the given user account", (Throwable)e);
            return false;
        }
        if (email == null || email.trim().equalsIgnoreCase("")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No email address associated with the given user account");
            }
            return false;
        }
        String confirmationKey = null;
        try {
            confirmationKey = PasswordUtil.generateConfirmationKey(tenantLessUserName, domainName);
        }
        catch (RegistryException e) {
            String msg = "Error in generating the confirmation key for the password reset";
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
        Map<String, String> dataToStore = PasswordUtil.populateDataMap(adminInfoBean, tenantLessUserName, userName, email, tenantId, confirmationKey);
        return PasswordUtil.verifyPasswordResetRequest(userName, dataToStore);
    }

    private static boolean verifyPasswordResetRequest(String userName, Map<String, String> dataToStore) throws AdminManagementException {
        boolean passwordReset;
        try {
            EmailVerifcationSubscriber emailVerifier = AdminManagementServiceComponent.getEmailVerificationService();
            emailVerifier.requestUserVerification(dataToStore, AdminManagementServiceComponent.getEmailVerifierConfig());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Email verification for the password reset.");
            }
            passwordReset = true;
        }
        catch (Exception e) {
            String msg = "Error in notifying the user " + userName;
            log.error((Object)msg);
            throw new AdminManagementException(msg, e);
        }
        return passwordReset;
    }

    private static String generateConfirmationKey(String adminName, String domain) throws RegistryException, AdminManagementException {
        String adminManagementPath;
        String confirmationKey = UUIDGenerator.generateUUID();
        UserRegistry superTenantGovernanceSystemRegistry = AdminManagementServiceComponent.getGovernanceSystemRegistry(-1234);
        Resource resource = superTenantGovernanceSystemRegistry.resourceExists(adminManagementPath = AdminMgtUtil.getAdminManagementPath(adminName, domain)) ? superTenantGovernanceSystemRegistry.get(adminManagementPath) : superTenantGovernanceSystemRegistry.newResource();
        resource.setContent((Object)confirmationKey);
        superTenantGovernanceSystemRegistry.put(adminManagementPath, resource);
        return confirmationKey;
    }

    private static Map<String, String> populateDataMap(AdminMgtInfoBean adminInfoBean, String tenantLessUserName, String userName, String email, int tenantId, String confirmationKey) throws AdminManagementException {
        HashMap<String, String> dataToStore = new HashMap<String, String>();
        dataToStore.put("email", email);
        dataToStore.put("first-name", ClaimsMgtUtil.getFirstName(AdminManagementServiceComponent.getRealmService(), tenantId));
        dataToStore.put("admin", tenantLessUserName);
        dataToStore.put("userName", userName);
        dataToStore.put("tenantDomain", adminInfoBean.getTenantDomain());
        dataToStore.put("confirmationKey", confirmationKey);
        return dataToStore;
    }

    private static String getEmailAddressForUser(String tenantLessUserName, String userName, int tenantId, Tenant tenant) throws AdminManagementException {
        String email = "";
        try {
            if (tenantId == -1234) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting email address for the super tenant user password reset");
                }
                email = ClaimsMgtUtil.getEmailAddressFromUserProfile(AdminManagementServiceComponent.getRealmService(), userName, tenantId);
                audit.info((Object)("Password reset link for the user " + userName + " of the super tenant" + " to be sent to the email address " + email));
            } else if (tenantId > 0) {
                String adminNameFromUserStore = ClaimsMgtUtil.getAdminUserNameFromTenantId(AdminManagementServiceComponent.getRealmService(), tenantId);
                email = PasswordUtil.getEmailAddressForTenants(userName, tenantLessUserName, tenantId, tenant, adminNameFromUserStore);
            }
        }
        catch (AdminManagementException e) {
            String msg = "Unable to retrieve an email address associated with the given user.";
            log.info((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, e);
        }
        return email;
    }

    private static String getEmailAddressForTenants(String userName, String adminName, int tenantId, Tenant tenant, String adminNameFromUserStore) throws AdminManagementException {
        String email = "";
        if (adminNameFromUserStore.equalsIgnoreCase(adminName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Password reset for a tenant admin");
            }
            email = tenant.getEmail();
            audit.info((Object)("Password reset link for the tenant admin " + userName + " of tenant id: " + tenantId + " to be sent to the email address " + email));
        } else if (!adminNameFromUserStore.equalsIgnoreCase(adminName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Password reset for a non-admin tenant user");
            }
            email = ClaimsMgtUtil.getEmailAddressFromUserProfile(AdminManagementServiceComponent.getRealmService(), userName, tenantId);
            audit.info((Object)("Password reset link for a user " + userName + " of the tenant of " + "tenant id: " + tenantId + " to be sent to the email address " + email));
        }
        return email;
    }

    private static boolean updatePassword(AdminMgtInfoBean adminInfoBean, UserStoreManager userStoreManager) throws AdminManagementException {
        String tenantLessUserName = adminInfoBean.getTenantLessUserName();
        String tenantDomain = adminInfoBean.getTenantDomain();
        String password = adminInfoBean.getPassword();
        String userName = AdminMgtUtil.getUserNameWithDomain(tenantLessUserName, tenantDomain);
        try {
            userStoreManager.updateCredentialByAdmin(tenantLessUserName, (Object)password);
            String msg = "Password reset for the user: " + userName;
            log.info((Object)msg);
            audit.info((Object)("Password for the user " + userName + " is successfully reset"));
            return true;
        }
        catch (UserStoreException e) {
            String msg = "Error in changing the password for user: " + userName;
            audit.error((Object)("Error in changing the password for the user: " + userName), (Throwable)e);
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
    }

    public static boolean updateCredentials(AdminMgtInfoBean adminInfoBean) throws AdminManagementException {
        UserRegistry configSystemRegistry;
        String tenantDomain = adminInfoBean.getTenantDomain();
        int tenantId = AdminMgtUtil.getTenantIdFromDomain(tenantDomain);
        try {
            configSystemRegistry = AdminManagementServiceComponent.getConfigSystemRegistry(tenantId);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the config system registry for the tenant, " + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
        boolean updatePassword = false;
        if (adminInfoBean.getPassword() != null && !adminInfoBean.getPassword().equals("")) {
            updatePassword = true;
        }
        UserRealm userRealm = configSystemRegistry.getUserRealm();
        try {
            UserStoreManager userStoreManager = userRealm.getUserStoreManager();
            if (!userStoreManager.isReadOnly() && updatePassword) {
                return PasswordUtil.updatePassword(adminInfoBean, userStoreManager);
            }
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the user store manager for the user.";
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
        return false;
    }

    public static boolean proceedUpdateCredentials(String domain, String adminName, String confirmationKey) throws AdminManagementException {
        String adminManagementPath = AdminMgtUtil.getAdminManagementPath(adminName, domain);
        try {
            UserRegistry superTenantSystemRegistry = AdminManagementServiceComponent.getGovernanceSystemRegistry(-1234);
            if (superTenantSystemRegistry.resourceExists(adminManagementPath)) {
                Resource resource = superTenantSystemRegistry.get(adminManagementPath);
                String actualConfirmationKey = null;
                Object content = resource.getContent();
                if (content instanceof String) {
                    actualConfirmationKey = (String)content;
                } else if (content instanceof byte[]) {
                    actualConfirmationKey = new String((byte[])content);
                }
                if (actualConfirmationKey != null && actualConfirmationKey.equals(confirmationKey)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Password resetting for the user of the domain: " + domain));
                    }
                    return true;
                }
                if (actualConfirmationKey == null || !actualConfirmationKey.equals(confirmationKey)) {
                    String msg = "The credential update confirmation key is not matching.";
                    log.error((Object)msg);
                    return false;
                }
            } else {
                log.warn((Object)"The confirmationKey doesn't exist in service.");
            }
        }
        catch (RegistryException e) {
            String msg = "Unable to verify the update credentials request";
            log.error((Object)msg, (Throwable)e);
            throw new AdminManagementException(msg, (Exception)((Object)e));
        }
        return false;
    }
}

