/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.admin.mgt.internal;

import java.io.File;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.email.verification.util.EmailVerifcationSubscriber;
import org.wso2.carbon.email.verification.util.EmailVerifierConfig;
import org.wso2.carbon.email.verification.util.Util;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class AdminManagementServiceComponent {
    private static Log log = LogFactory.getLog(AdminManagementServiceComponent.class);
    private static ConfigurationContextService configurationContextService;
    private static RealmService realmService;
    private static RegistryService registryService;
    private static EmailVerifcationSubscriber emailVerificationService;
    private static EmailVerifierConfig emailVerifierConfig;

    protected void activate(ComponentContext context) {
        AdminManagementServiceComponent.loadEmailVerifierConfig();
        log.debug((Object)"******* Admin Management bundle is activated ******* ");
        try {
            log.debug((Object)"******* Admin Management bundle is activated ******* ");
        }
        catch (Exception e) {
            log.debug((Object)"******* Failed to activate Admin Management bundle ******* ");
        }
    }

    public static void loadEmailVerifierConfig() {
        String confXml = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-admin-config.xml";
        try {
            emailVerifierConfig = Util.loadeMailVerificationConfig((String)confXml);
        }
        catch (Exception e) {
            String msg = "Email Configuration file for the password reset feature not found. Pls check the repository/conf/email folder for email-admin-config.xml";
            log.error((Object)msg);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Admin Management bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        AdminManagementServiceComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.setRegistryService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Receiving ConfigurationContext Service");
        AdminManagementServiceComponent.configurationContextService = configurationContextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"Unsetting ConfigurationContext Service");
        this.setConfigurationContextService(null);
    }

    public static ConfigurationContext getConfigurationContext() {
        if (configurationContextService.getServerConfigContext() == null) {
            return null;
        }
        return configurationContextService.getServerConfigContext();
    }

    protected void setRealmService(RealmService realmService) {
        AdminManagementServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        this.setRealmService(null);
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static TenantManager getTenantManager() {
        return realmService.getTenantManager();
    }

    public static RealmConfiguration getBootstrapRealmConfiguration() {
        return realmService.getBootstrapRealmConfiguration();
    }

    public static UserRegistry getGovernanceSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getGovernanceSystemRegistry(tenantId);
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static UserRegistry getConfigSystemRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }

    protected void setEmailVerificationService(EmailVerifcationSubscriber emailService) {
        emailVerificationService = emailService;
    }

    protected void unsetEmailVerificationService(EmailVerifcationSubscriber emailService) {
        this.setEmailVerificationService(null);
    }

    public static EmailVerifcationSubscriber getEmailVerificationService() {
        return emailVerificationService;
    }

    public static EmailVerifierConfig getEmailVerifierConfig() {
        return emailVerifierConfig;
    }

    static {
        emailVerificationService = null;
        emailVerifierConfig = null;
    }
}

