/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.account.mgt.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.account.mgt.stub.services.BillingDataAccessServiceStub;
import org.wso2.carbon.account.mgt.stub.services.beans.xsd.Subscription;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class UsagePlanClient {
    private BillingDataAccessServiceStub stub;
    private static final Log log = LogFactory.getLog(UsagePlanClient.class);

    public UsagePlanClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String epr = backendServerURL + "BillingDataAccessService";
        try {
            this.stub = new BillingDataAccessServiceStub(configContext, epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public boolean updateUsagePlan(String usagePlanName) {
        try {
            this.stub.changeSubscriptionByTenant(usagePlanName);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getUsagePlanName(String tenantDomain) throws Exception {
        try {
            Subscription subscription = this.stub.getActiveSubscriptionOfCustomerByTenant();
            if (subscription != null) {
                return subscription.getSubscriptionPlan();
            }
            return "";
        }
        catch (Exception e) {
            String msg = "Error occurred while getting the usage plan for tenant: " + tenantDomain;
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public boolean deactivateActiveUsagePlan(String tenantDomain) {
        log.info((Object)("Deactivating tenant domain: " + tenantDomain));
        boolean deactivated = false;
        try {
            deactivated = this.stub.deactivateActiveSubscriptionByTenant();
            if (deactivated) {
                log.info((Object)("Active subscription deactivated after deactivating the tenant: " + tenantDomain));
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while deactivating active subscription of: " + tenantDomain + " " + e.getMessage()), (Throwable)e);
        }
        return deactivated;
    }
}

