/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.account.mgt.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.account.mgt.stub.beans.xsd.AccountInfoBean;
import org.wso2.carbon.account.mgt.stub.services.AccountMgtServiceStub;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class AccountMgtClient {
    private static final Log log = LogFactory.getLog(AccountMgtClient.class);
    private AccountMgtServiceStub stub;
    private String epr;

    public AccountMgtClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "AccountMgtService";
        try {
            this.stub = new AccountMgtServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AccountMgt service client.";
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public AccountMgtClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "AccountMgtService";
        try {
            this.stub = new AccountMgtServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AccountMgt service client.";
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public void updateContact(String contactEmail) throws RegistryException {
        try {
            this.stub.updateContact(contactEmail);
        }
        catch (Exception e) {
            String msg = "Failed to update contact.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public String getContact() throws RegistryException {
        try {
            return this.stub.getContact();
        }
        catch (Exception e) {
            String msg = "Failed to get contact.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean updateFullname(AccountInfoBean fullname) throws RegistryException {
        try {
            return this.stub.updateFullname(fullname);
        }
        catch (Exception e) {
            String msg = "Failed to update Fullname.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public AccountInfoBean getFullname() throws RegistryException {
        try {
            return this.stub.getFullname();
        }
        catch (Exception e) {
            String msg = "Failed to get administrator full name.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public void deactivate() throws RegistryException {
        try {
            this.stub.deactivate();
        }
        catch (Exception e) {
            String msg = "Failed to deactivate.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean isDomainValidated() throws RegistryException {
        try {
            return this.stub.isDomainValidated();
        }
        catch (Exception e) {
            String msg = "Failed to check the domain validation.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean finishedDomainValidation(String validatedDomain, String successKey) throws RegistryException {
        try {
            return this.stub.finishedDomainValidation(validatedDomain, successKey);
        }
        catch (Exception e) {
            String msg = "Failed to finish the domain validation.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean checkDomainAvailability(String domainName) throws RegistryException {
        try {
            return this.stub.checkDomainAvailability(domainName);
        }
        catch (Exception e) {
            String msg = "Failed to finish the domain availability.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public boolean isEmailValidated() throws RegistryException {
        try {
            return this.stub.isEmailValidated();
        }
        catch (Exception e) {
            String msg = "Failed to check the email validation.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }
}

