/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.utils.webapp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebAppUtil {
    private static final Log log = LogFactory.getLog(WebAppUtil.class);

    protected static boolean webappTest(String url, String content) throws IOException {
        boolean webappStatus = false;
        URL u = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)u.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        int code = connection.getResponseCode();
        if (code == 200) {
            String inputLine;
            log.info((Object)"Connected to webapp successfully");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.indexOf(content) <= 1) continue;
                log.info((Object)("Webapp output text " + content + " found"));
                webappStatus = true;
                break;
            }
            in.close();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("webapp connection returned HTTP " + code + " error"));
        }
        return webappStatus;
    }

    public static void waitForWebAppDeployment(String serviceUrl, String content) throws Exception {
        int serviceTimeOut = 0;
        try {
            while (!WebAppUtil.webappTest(serviceUrl, content)) {
                if (serviceTimeOut != 0 && serviceTimeOut > 100) {
                    throw new Exception(serviceUrl + " webapp is not found");
                }
                try {
                    Thread.sleep(500L);
                    ++serviceTimeOut;
                }
                catch (InterruptedException ignored) {}
            }
        }
        catch (IOException e) {
            log.error((Object)("Unable to wait for webapp deployment: IO Exception" + e));
            throw new IOException("Unable to wait for webapp deployment" + e);
        }
    }

    public static void waitForWebAppUnDeployment(String serviceUrl, String content) throws Exception {
        int serviceTimeOut = 0;
        try {
            while (WebAppUtil.webappTest(serviceUrl, content)) {
                if (serviceTimeOut != 0 && serviceTimeOut > 60) {
                    throw new Exception("webapp undeployment failed");
                }
                try {
                    Thread.sleep(500L);
                    ++serviceTimeOut;
                }
                catch (InterruptedException ignored) {}
            }
        }
        catch (IOException e) {
            log.error((Object)("Unable to wait for webapp deployment" + e));
            throw new IOException("Unable to wait for webapp deployment" + e);
        }
    }
}

