/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.utils.selenium;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.testng.Assert;

public class GRegSeleniumUtils {
    private static final Log log = LogFactory.getLog(GRegSeleniumUtils.class);

    public static int getResourceId(WebDriver driver, String resourceName) {
        long actualTime;
        int pageCount = 10;
        int id = 0;
        long currentTime = System.currentTimeMillis();
        do {
            if (!driver.getPageSource().contains(resourceName)) continue;
            for (int i = 1; i <= pageCount; ++i) {
                if (!driver.findElement(By.id((String)("resourceView" + i))).getText().equals(resourceName) && !driver.findElement(By.id((String)("resourceView" + i))).getText().equals(resourceName + " " + "..")) continue;
                return i;
            }
        } while (((actualTime = System.currentTimeMillis()) - currentTime) / 1000L <= 10L);
        return id;
    }

    public static void deleteResourceFromBrowser(WebDriver driver, String resourceName) {
        int resourceRowId = GRegSeleniumUtils.getResourceId(driver, resourceName);
        if (resourceRowId != 0) {
            try {
                driver.findElement(By.id((String)("actionLink" + resourceRowId))).click();
                resourceRowId = (resourceRowId - 1) * 7 + 2;
                driver.findElement(By.xpath((String)("//tr[2]/td[3]/table/tbody/tr[2]/td/div/div/table/tbody/tr/td/div[2]/div[3]/div[3]/div[9]/table/tbody/tr[" + resourceRowId + "]/td/div/a[3]"))).click();
                Assert.assertTrue((boolean)driver.findElement(By.id((String)"ui-dialog-title-dialog")).getText().contains("WSO2 Carbon"), (String)"Popup not found :");
                driver.findElement(By.xpath((String)"//button")).click();
            }
            catch (WebDriverException ignored) {
                log.info((Object)"Web element not found");
            }
            GRegSeleniumUtils.gotoDetailViewTab(driver);
        }
    }

    public static boolean waitForBrowserPage(WebDriver driver) {
        long exceededTime;
        long currentTime = System.currentTimeMillis();
        do {
            try {
                if (driver.findElement(By.id((String)"middle")).findElement(By.tagName((String)"h2")).getText().contains("Browse")) {
                    return true;
                }
            }
            catch (WebDriverException ignored) {
                log.info((Object)"Waiting for the element");
            }
        } while (((exceededTime = System.currentTimeMillis()) - currentTime) / 1000L <= 60L);
        return false;
    }

    public static boolean waitForElement(WebDriver driver, String elementType, String element) {
        long exceededTime;
        long currentTime = System.currentTimeMillis();
        Boolean status = false;
        do {
            try {
                if (elementType.equals("xpath")) {
                    if (!driver.findElement(By.xpath((String)element)).isDisplayed()) continue;
                    status = true;
                    break;
                }
                if (!elementType.equals("id") || !driver.findElement(By.id((String)element)).isDisplayed()) continue;
                status = true;
                break;
            }
            catch (WebDriverException ignored) {
                log.info((Object)"Waiting for the element");
            }
        } while (((exceededTime = System.currentTimeMillis()) - currentTime) / 1000L <= 60L);
        Assert.assertTrue((boolean)status, (String)("Element not found within 60 sec - " + element));
        return status;
    }

    private static void gotoDetailViewTab(WebDriver driver) {
        driver.findElement(By.linkText((String)"Browse")).click();
        GRegSeleniumUtils.waitForBrowserPage(driver);
        driver.findElement(By.id((String)"stdView")).click();
    }
}

