/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.utils.registry;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.automation.api.clients.authenticators.AuthenticatorClient;
import org.wso2.carbon.automation.api.clients.user.mgt.UserManagementClient;
import org.wso2.carbon.automation.core.utils.UserInfo;
import org.wso2.carbon.automation.core.utils.UserListCsvReader;
import org.wso2.carbon.automation.core.utils.frameworkutils.FrameworkFactory;
import org.wso2.carbon.automation.core.utils.frameworkutils.FrameworkProperties;
import org.wso2.carbon.user.mgt.common.UserAdminException;

public class RegistryUserCreator {
    private static final Log log = LogFactory.getLog(RegistryUserCreator.class);
    private UserManagementClient userAdminStub;
    private String sessionCookie;

    protected static String login(String userName, String password, String hostName) throws RemoteException, LoginAuthenticationExceptionException {
        AuthenticatorClient loginClient = new AuthenticatorClient(hostName);
        return loginClient.login(userName, password, hostName);
    }

    public void deleteUsers(int userId, String userID) throws Exception {
        this.setInfoRolesAndUsers(userId);
        this.userAdminStub.deleteUser(userID);
    }

    public void addUser(int userId, String userID, String userPassword, String roleName) throws Exception {
        this.setInfoRolesAndUsers(userId);
        try {
            String[] roles = new String[]{roleName};
            this.userAdminStub.addUser(userID, userPassword, roles, null);
        }
        catch (UserAdminException e) {
            log.error((Object)("Add user fail" + (Object)((Object)e)));
            throw new UserAdminException("Add user fail" + (Object)((Object)e));
        }
    }

    public void setInfoRolesAndUsers(int userId) throws LoginAuthenticationExceptionException, RemoteException {
        FrameworkProperties isProperties = FrameworkFactory.getFrameworkProperties((String)"IS");
        UserInfo userAdminDetails = UserListCsvReader.getUserInfo((int)userId);
        this.sessionCookie = RegistryUserCreator.login(userAdminDetails.getUserName(), userAdminDetails.getPassword(), isProperties.getProductVariables().getBackendUrl());
        this.userAdminStub = new UserManagementClient(isProperties.getProductVariables().getBackendUrl(), this.sessionCookie);
    }
}

