/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.utils.registry;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.core.ProductConstant;
import org.wso2.carbon.automation.core.utils.UserInfo;
import org.wso2.carbon.automation.core.utils.UserListCsvReader;
import org.wso2.carbon.automation.core.utils.coreutils.PlatformUtil;
import org.wso2.carbon.automation.core.utils.environmentutils.EnvironmentBuilder;
import org.wso2.carbon.automation.core.utils.environmentutils.ProductUrlGeneratorUtil;
import org.wso2.carbon.automation.core.utils.frameworkutils.FrameworkFactory;
import org.wso2.carbon.automation.core.utils.frameworkutils.FrameworkProperties;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.ws.client.registry.WSRegistryServiceClient;

public class RegistryProviderUtil {
    private static final Log log = LogFactory.getLog(RegistryProviderUtil.class);

    public WSRegistryServiceClient getWSRegistry(int userID, String productName) throws RegistryException, AxisFault {
        String serverURL;
        String password;
        String userName;
        UserInfo userDetails;
        WSRegistryServiceClient registry = null;
        EnvironmentBuilder env = new EnvironmentBuilder();
        if (env.getFrameworkSettings().getEnvironmentSettings().is_runningOnStratos()) {
            userDetails = UserListCsvReader.getUserInfo((int)userID);
            userName = userDetails.getUserName();
            password = userDetails.getPassword();
            serverURL = RegistryProviderUtil.getServiceURL(productName);
        } else {
            userDetails = UserListCsvReader.getUserInfo((int)userID);
            userName = userDetails.getUserName();
            password = userDetails.getPassword();
            serverURL = RegistryProviderUtil.getServiceURL(productName);
        }
        String axis2Repo = ProductConstant.getModuleClientPath();
        String axis2Conf = ProductConstant.SYSTEM_TEST_RESOURCE_LOCATION + File.separator + "axis2config" + File.separator + "axis2_client.xml";
        PlatformUtil.setKeyStoreProperties();
        try {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)axis2Repo, (String)axis2Conf);
            int timeOutInMilliSeconds = 60000;
            configContext.setProperty("CONNECTION_TIMEOUT", (Object)timeOutInMilliSeconds);
            log.info((Object)("Group ConfigurationContext Timeout " + configContext.getServiceGroupContextTimeoutInterval()));
            registry = new WSRegistryServiceClient(serverURL, userName, password, configContext);
            log.info((Object)"WS Registry -Login Success");
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Unable to initialize WSRegistryServiceClient :" + axisFault.getMessage()));
            throw new AxisFault("Unable to initialize WSRegistryServiceClient :" + axisFault.getMessage());
        }
        catch (RegistryException e) {
            log.error((Object)("Unable to initialize WSRegistryServiceClient:" + (Object)((Object)e)));
            throw new RegistryException("Unable to initialize WSRegistryServiceClient:" + (Object)((Object)e));
        }
        return registry;
    }

    public Registry getGovernanceRegistry(WSRegistryServiceClient registry, int userId) throws RegistryException {
        Registry governance;
        UserInfo userDetails = UserListCsvReader.getUserInfo((int)userId);
        String userName = userDetails.getUserName();
        PlatformUtil.setKeyStoreProperties();
        try {
            governance = GovernanceUtils.getGovernanceUserRegistry((Registry)registry, (String)userName);
        }
        catch (RegistryException e) {
            log.error((Object)("getGovernance Registry Exception thrown:" + (Object)((Object)e)));
            throw new RegistryException("getGovernance Registry Exception thrown:" + (Object)((Object)e));
        }
        return governance;
    }

    public RemoteRegistry getRemoteRegistry(int userId, String productName) throws MalformedURLException, RegistryException {
        RemoteRegistry registry;
        UserInfo userDetails = UserListCsvReader.getUserInfo((int)userId);
        String username = userDetails.getUserName();
        String password = userDetails.getPassword();
        EnvironmentBuilder env = new EnvironmentBuilder();
        FrameworkProperties properties = FrameworkFactory.getFrameworkProperties((String)productName);
        String registryURL = env.getFrameworkSettings().getEnvironmentSettings().is_runningOnStratos() ? ProductUrlGeneratorUtil.getRemoteRegistryURLOfStratos((String)properties.getProductVariables().getHttpsPort(), (String)properties.getProductVariables().getHostName(), (FrameworkProperties)properties, (UserInfo)userDetails) : ProductUrlGeneratorUtil.getRemoteRegistryURLOfProducts((String)properties.getProductVariables().getHttpsPort(), (String)properties.getProductVariables().getHostName(), (String)properties.getProductVariables().getWebContextRoot());
        log.info((Object)("Remote Registry URL" + registryURL));
        try {
            registry = new RemoteRegistry(new URL(registryURL), username, password);
        }
        catch (RegistryException e) {
            log.error((Object)("Error on initializing Remote Registry :" + (Object)((Object)e)));
            throw new RegistryException("Error on initializing Remote Registry error  :" + (Object)((Object)e));
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid registry URL :" + e));
            throw new MalformedURLException("Invalid registry URL" + e);
        }
        return registry;
    }

    private static String getServiceURL(String productName) {
        FrameworkProperties gregProperties = FrameworkFactory.getFrameworkProperties((String)productName);
        String serverURL = gregProperties.getProductVariables().getBackendUrl();
        log.info((Object)("Server URL is :" + serverURL));
        return serverURL;
    }
}

