/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.utils.esb;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;

public class StockQuoteClient {
    private static final Log log = LogFactory.getLog(StockQuoteClient.class);
    private ConfigurationContext cfgCtx;
    private ServiceClient serviceClient;
    private List<Header> httpHeaders = new ArrayList<Header>();

    public StockQuoteClient() {
        String repositoryPath = "samples" + File.separator + "axis2Client" + File.separator + "client_repo";
        File repository = new File(repositoryPath);
        log.info((Object)("Using the Axis2 repository path: " + repository.getAbsolutePath()));
        try {
            this.cfgCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repository.getCanonicalPath(), null);
            this.serviceClient = new ServiceClient(this.cfgCtx, null);
            log.info((Object)"Sample client initialized successfully...");
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing the StockQuoteClient", (Throwable)e);
        }
    }

    public void setHeader(String localName, String ns, String value) throws AxisFault {
        this.serviceClient.addStringHeader(new QName(ns, localName), value);
    }

    public OMElement sendSimpleStockQuoteRequest(String trpUrl, String addUrl, String symbol) throws AxisFault {
        Options options = this.getOptions(trpUrl, addUrl);
        this.serviceClient.setOptions(options);
        return this.serviceClient.sendReceive(this.createStandardRequest(symbol));
    }

    public OMElement sendSimpleStockQuoteRequest(String trpUrl, String addUrl, OMElement payload) throws AxisFault {
        Options options = this.getOptions(trpUrl, addUrl);
        this.serviceClient.setOptions(options);
        return this.serviceClient.sendReceive(payload);
    }

    public OMElement sendSecuredSimpleStockQuoteRequest(String trpUrl, String addUrl, String symbol, String policyPath) throws Exception {
        Options options = this.getOptions(trpUrl, addUrl);
        if (policyPath != null && !policyPath.equals("")) {
            this.serviceClient.engageModule("addressing");
            this.serviceClient.engageModule("rampart");
            options.setProperty("rampartPolicy", (Object)StockQuoteClient.loadPolicy(policyPath));
        }
        this.serviceClient.setOptions(options);
        return this.serviceClient.sendReceive(this.createStandardRequest(symbol));
    }

    public OMElement sendCustomQuoteRequest(String trpUrl, String addUrl, String symbol) throws AxisFault {
        Options options = this.getOptions(trpUrl, addUrl);
        this.serviceClient.setOptions(options);
        return this.serviceClient.sendReceive(this.createCustomQuoteRequest(symbol));
    }

    public OMElement sendMultipleQuoteRequest(String trpUrl, String addUrl, String symbol, int n) throws AxisFault {
        Options options = this.getOptions(trpUrl, addUrl);
        this.serviceClient.setOptions(options);
        return this.serviceClient.sendReceive(this.createMultipleQuoteRequest(symbol, n));
    }

    private Options getOptions(String trpUrl, String addUrl) throws AxisFault {
        Options options = new Options();
        if (trpUrl != null && !"null".equals(trpUrl)) {
            options.setProperty("TransportURL", (Object)trpUrl);
        }
        if (addUrl != null && !"null".equals(addUrl)) {
            this.serviceClient.engageModule("addressing");
            options.setTo(new EndpointReference(addUrl));
        }
        options.setAction("urn:getQuote");
        if (this.httpHeaders.size() > 0) {
            options.setProperty("HTTP_HEADERS", this.httpHeaders);
        }
        return options;
    }

    public void destroy() {
        try {
            this.serviceClient.cleanup();
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while cleaning up the service client", (Throwable)axisFault);
        }
        this.cfgCtx.cleanupContexts();
        this.serviceClient = null;
        this.cfgCtx = null;
    }

    public void addHttpHeader(String name, String value) {
        this.httpHeaders.add(new Header(name, value));
    }

    private OMElement createStandardRequest(String symbol) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = fac.createOMElement("getQuote", omNs);
        OMElement value1 = fac.createOMElement("request", omNs);
        OMElement value2 = fac.createOMElement("symbol", omNs);
        value2.addChild((OMNode)fac.createOMText((OMContainer)value1, symbol));
        value1.addChild((OMNode)value2);
        method.addChild((OMNode)value1);
        return method;
    }

    private OMElement createMultipleQuoteRequest(String symbol, int iterations) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://services.samples", "ns");
        OMElement method = fac.createOMElement("getQuote", omNs);
        for (int i = 0; i < iterations; ++i) {
            OMElement value1 = fac.createOMElement("request", omNs);
            OMElement value2 = fac.createOMElement("symbol", omNs);
            value2.addChild((OMNode)fac.createOMText((OMContainer)value1, symbol));
            value1.addChild((OMNode)value2);
            method.addChild((OMNode)value1);
        }
        return method;
    }

    private OMElement createCustomQuoteRequest(String symbol) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples", "ns");
        OMElement chkPrice = factory.createOMElement("CheckPriceRequest", ns);
        OMElement code = factory.createOMElement("Code", ns);
        chkPrice.addChild((OMNode)code);
        code.setText(symbol);
        return chkPrice;
    }

    private static Policy loadPolicy(String xmlPath) throws Exception {
        StAXOMBuilder builder = new StAXOMBuilder(xmlPath);
        return PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
    }
}

