/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.utils.esb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.api.clients.mediation.SynapseConfigAdminClient;

public class ESBTestCaseUtils {
    private static final int ESB_HTTP_PORT = 8280;
    private static final int ESB_HTTPS_PORT = 8243;
    private static final int ESB_SERVLET_HTTP_PORT = 9763;
    private static final int ESB_SERVLET_HTTPS_PORT = 9443;
    protected Log log = LogFactory.getLog(this.getClass());

    public OMElement loadClasspathResource(String path) {
        OMElement documentElement = null;
        File file = new File(this.getClass().getResource(path).getPath());
        if (file.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(this.getClass().getResource(path).getPath());
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                documentElement = builder.getDocumentElement();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }
        return documentElement;
    }

    public void loadESBConfigurationFromClasspath(String filePath, String backendURL, String sessionCookie) throws RemoteException, XMLStreamException, ServletException {
        OMElement configElement = this.loadClasspathResource(filePath);
        this.updateESBConfiguration(configElement, backendURL, sessionCookie);
    }

    public void loadSampleESBConfiguration(int number, String backendURL, String sessionCookie) throws Exception {
        String filePath = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "samples" + File.separator + "synapse_sample_" + number + ".xml";
        File configFile = new File(filePath);
        FileInputStream inputStream = new FileInputStream(configFile.getAbsolutePath());
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement documentElement = builder.getDocumentElement();
        this.updateESBConfiguration(documentElement, backendURL, sessionCookie);
    }

    private void updateESBConfiguration(OMElement config, String backendURL, String sessionCookie) throws RemoteException, XMLStreamException, ServletException {
        SynapseConfigAdminClient synapseConfigAdminClient = new SynapseConfigAdminClient(backendURL, sessionCookie);
        synapseConfigAdminClient.updateConfiguration(config);
    }
}

