/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.utils.axis2client;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.security.WSPasswordCallback;
import org.testng.Assert;
import org.wso2.carbon.automation.core.ProductConstant;
import org.wso2.carbon.automation.core.utils.environmentutils.EnvironmentBuilder;

public class SecureAxisServiceClient
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(SecureAxisServiceClient.class);

    public OMElement sendReceive(String userName, String password, String endpointReference, String operation, OMElement payload, int securityScenarioNo) throws Exception {
        OMElement result;
        ServiceClient sc = this.getServiceClient(userName, password, endpointReference, operation, securityScenarioNo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("payload :" + payload));
            log.debug((Object)("Security Scenario No :" + securityScenarioNo));
            log.debug((Object)("Operation :" + operation));
            log.debug((Object)("username :" + userName));
            log.debug((Object)("password :" + password));
        }
        log.info((Object)("Endpoint reference :" + endpointReference));
        try {
            result = sc.sendReceive(payload);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response :" + result));
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault : " + axisFault.getMessage()));
            throw new AxisFault("AxisFault : " + axisFault.getMessage(), (Throwable)axisFault);
        }
        Assert.assertNotNull((Object)result);
        return result;
    }

    public void sendRobust(String userName, String password, String endpointReference, String operation, OMElement payload, int securityScenarioNo) throws Exception {
        ServiceClient sc = this.getServiceClient(userName, password, endpointReference, operation, securityScenarioNo);
        try {
            sc.sendRobust(payload);
            log.info((Object)"Request Sent");
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault : " + axisFault.getMessage()));
            throw new AxisFault("AxisFault : " + axisFault.getMessage(), (Throwable)axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy loadPolicy(String userName, String securityPolicyPath, String keyPath) throws Exception {
        Policy policy = null;
        StAXOMBuilder builder = null;
        try {
            builder = new StAXOMBuilder(securityPolicyPath);
            policy = PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
            RampartConfig rc = new RampartConfig();
            rc.setUser(userName);
            rc.setUserCertAlias("wso2carbon");
            rc.setEncryptionUser("wso2carbon");
            rc.setPwCbClass(SecureAxisServiceClient.class.getName());
            String pass = "wso2carbon";
            CryptoConfig sigCryptoConfig = new CryptoConfig();
            sigCryptoConfig.setProvider("org.apache.ws.security.components.crypto.Merlin");
            Properties prop1 = new Properties();
            prop1.put("org.apache.ws.security.crypto.merlin.keystore.type", "JKS");
            prop1.put("org.apache.ws.security.crypto.merlin.file", keyPath);
            prop1.put("org.apache.ws.security.crypto.merlin.keystore.password", pass);
            sigCryptoConfig.setProp(prop1);
            CryptoConfig encrCryptoConfig = new CryptoConfig();
            encrCryptoConfig.setProvider("org.apache.ws.security.components.crypto.Merlin");
            Properties prop2 = new Properties();
            prop2.put("org.apache.ws.security.crypto.merlin.keystore.type", "JKS");
            prop2.put("org.apache.ws.security.crypto.merlin.file", keyPath);
            prop2.put("org.apache.ws.security.crypto.merlin.keystore.password", pass);
            encrCryptoConfig.setProp(prop2);
            rc.setSigCryptoConfig(sigCryptoConfig);
            rc.setEncrCryptoConfig(encrCryptoConfig);
            policy.addAssertion((Assertion)rc);
        }
        finally {
            if (builder != null) {
                builder.close();
            }
        }
        Assert.assertNotNull((Object)policy, (String)"Policy cannot be null");
        return policy;
    }

    private ServiceClient getServiceClient(String userName, String password, String endpointReference, String operation, int securityScenarioNo) throws Exception {
        ServiceClient sc;
        EnvironmentBuilder environmentBuilder = new EnvironmentBuilder();
        String keyPath = environmentBuilder.getFrameworkSettings().getEnvironmentVariables().getKeystorePath();
        String securityPolicyPath = ProductConstant.getSecurityScenarios() + File.separator + "scenario" + securityScenarioNo + "-policy.xml";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Key_Path :" + keyPath));
            log.debug((Object)("securityPolicyPath :" + securityPolicyPath));
        }
        System.setProperty("javax.net.ssl.trustStore", keyPath);
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        if (log.isDebugEnabled()) {
            log.debug((Object)("javax.net.ssl.trustStore :" + System.getProperty("javax.net.ssl.trustStore")));
            log.debug((Object)("javax.net.ssl.trustStorePassword :" + System.getProperty("javax.net.ssl.trustStorePassword")));
        }
        try {
            ConfigurationContext ctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)ProductConstant.getModuleClientPath(), null);
            sc = new ServiceClient(ctx, null);
            sc.engageModule("rampart");
            sc.engageModule("addressing");
            Options opts = new Options();
            if (securityScenarioNo == 1) {
                Assert.assertTrue((boolean)endpointReference.startsWith("https:"), (String)"Endpoint reference should be https");
            } else {
                Assert.assertTrue((boolean)endpointReference.startsWith("http:"), (String)"Endpoint reference should be https");
            }
            opts.setTo(new EndpointReference(endpointReference));
            opts.setAction("urn:" + operation);
            opts.setUserName(userName);
            opts.setPassword(password);
            try {
                if (securityScenarioNo >= 1) {
                    opts.setProperty("rampartPolicy", (Object)this.loadPolicy(userName, securityPolicyPath, keyPath));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new Exception(e.getMessage(), e);
            }
            sc.setOptions(opts);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("AxisFault : " + axisFault.getMessage()));
            throw new RuntimeException("AxisFault : " + axisFault.getMessage(), axisFault);
        }
        Assert.assertNotNull((Object)("ServiceClient object is null" + sc));
        return sc;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        WSPasswordCallback pwcb = (WSPasswordCallback)callbacks[0];
        String id = pwcb.getIdentifer();
        int usage = pwcb.getUsage();
        if (usage == 3 || usage == 1) {
            if ("client".equals(id)) {
                pwcb.setPassword("apache");
            }
            if ("service".equals(id)) {
                pwcb.setPassword("apache");
            }
            if ("wso2carbon".equals(id)) {
                pwcb.setPassword("wso2carbon");
            }
        }
    }
}

